package com.elitescloud.cloudt.revision.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.revision.vo.param.ComDistrictQueryParamVO;
import com.elitescloud.cloudt.revision.vo.resp.ComDistrictComboVO;
import com.elitescloud.cloudt.revision.vo.resp.ComDistrictRespVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Mir
 * @date 2020/7/31
 */
@Deprecated(forRemoval = true, since = "0.3.0")
@Unicom(domain = InvokeDomain.SYSTEM, path = ComDistrictProviderService.URI)
public interface ComDistrictProviderService {

    String URI = Application.URI_PREFIX + "/deprecated" + "/district/provider";

    @PostMapping(value = "/search")
    PagingVO<ComDistrictRespVO> search(@RequestBody ComDistrictQueryParamVO param);

    @GetMapping(value = "/listByPId")
    List<ComDistrictRespVO> listByPId(@RequestParam("pId") Long pId);

    @GetMapping(value = "/listByPCode")
    List<ComDistrictComboVO> listByPCode(@RequestParam("pCode") String pCode);

    @GetMapping(value = "/listByPCode2")
    List<ComDistrictComboVO> listByPCode2(@RequestParam("pCode") String pCode);

    @GetMapping(value = "/listByDistLevelNum")
    List<ComDistrictComboVO> listByDistLevelNum(@RequestParam("distLevelNum") Integer distLevelNum);

    @GetMapping(value = "/getById")
    ComDistrictRespVO getById(@RequestParam("id") Long id);

    @PostMapping(value = "/getByDistCodes")
    List<ComDistrictComboVO> getByDistCodes(@RequestBody List<String> distCodes);

    @PostMapping(value = "/getCityByDistCodes")
    List<ComDistrictComboVO> getCityByDistCodes(@RequestBody List<String> distCodes, @RequestParam("distLevelNum") String distLevelNum);

}
