package com.elitescloud.cloudt.revision.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.revision.vo.param.ComCommonTaxRateQueryParamVO;
import com.elitescloud.cloudt.revision.vo.param.ComTaxRateQueryParamDTO;
import com.elitescloud.cloudt.revision.vo.param.ComTaxRateQueryParamVO;
import com.elitescloud.cloudt.revision.vo.resp.ComCommonTaxRateRespVO;
import com.elitescloud.cloudt.revision.vo.resp.ComTaxRateRespVO;
import com.elitescloud.cloudt.revision.vo.resp.ComTaxRateVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 税率
 * </p>
 *
 * @author zhenghaiyang
 * @date 2020/7/2
 */
@Deprecated(forRemoval = true, since = "0.3.0")
@Unicom(domain = InvokeDomain.SYSTEM, path = ComTaxRateProviderService.URI)
public interface ComTaxRateProviderService {

    String URI = Application.URI_PREFIX + "/deprecated" + "/tax/rate/provider";

    @PostMapping(value = "/findBytaxRateNoList")
    List<ComTaxRateVO> findBytaxRateNoList(@RequestBody List<String> strings);

    /**
     * 查找税率共通方法
     *
     * @param param 单个入参
     * @return 返回 单个税率
     * @author 常昊阳 haoyang.chang@elitesland.com
     */
    @PostMapping(value = "/getRatioOrNull")
    ComCommonTaxRateRespVO getRatioOrNull(@RequestBody ComCommonTaxRateQueryParamVO param);

    /**
     * 根据税率编号及索引查询唯一税率 liuqi 2020.10.23
     *
     * @param taxRateNo    税率编号
     * @param taxRateIndex 税率索引
     * @return 税率
     */
    @GetMapping(value = "/findByTaxRateNoAndIndexOrNull")
    ComTaxRateVO findByTaxRateNoAndIndexOrNull(@RequestParam("taxRateNo") String taxRateNo, @RequestParam("taxRateIndex") String taxRateIndex);

    /**
     * @param taxRateNo, taxRateIndex
     * @return java.util.Optional<com.elitesland.basic.vo.ComTaxRateVO>
     * @Author Kevin.yuan
     * @Data 2020/12/10 10:10
     **/
    @PostMapping(value = "/findBytaxRateNoInAndIndexIn")
    List<ComTaxRateRespVO> findBytaxRateNoInAndIndexIn(@RequestParam("taxRateNo") Set<String> taxRateNo, @RequestParam("taxRateIndex") Set<String> taxRateIndex);

    @PostMapping(value = "/searchAll")
    PagingVO<ComTaxRateRespVO> searchAll(@RequestBody ComTaxRateQueryParamVO param);

    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    @PostMapping(value = "/search")
    PagingVO<ComTaxRateRespVO> search(@RequestBody ComTaxRateQueryParamVO queryParam);

    /**
     * 根据关键字段，返回对应的vo
     *
     * @param Code code
     * @return 对象
     */
    @GetMapping(value = "/getCodeOne")
    ComTaxRateRespVO getCodeOne(@RequestParam("Code") String Code);

    /**
     * 根据关键字段，返回对应的
     *
     * @param Id ID
     * @return 对象
     */
    @GetMapping(value = "/getIdOne")
    ComTaxRateRespVO getIdOne(@RequestParam("Id") Long Id);

    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    @PostMapping(value = "/findIdBatch")
    List<ComTaxRateRespVO> findIdBatch(@RequestBody List<Long> idList);

    /**
     * 查询税率
     *
     * @param queryParamDTO 查询参数
     * @return 税率列表
     */
    @PostMapping(value = "/query")
    List<ComTaxRateRespVO> query(@RequestBody ComTaxRateQueryParamDTO queryParamDTO);
}
