package com.elitescloud.cloudt.revision.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.param.SysUdcQueryParam;
import com.elitescloud.cloudt.system.vo.SysUdcComboVO;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * @date 2020/6/25
 */
@Deprecated(forRemoval = true)
@Unicom(domain = InvokeDomain.SYSTEM, path = SysUdcService.URI)
public interface SysUdcService {

    String URI = Application.URI_PREFIX + "/udc/revision";

    /**
     * 根据关键字段，返回对应的分类码
     *
     * @param domainCode 领域码
     * @param udcCode    分类码
     * @param udcVal     分类码值
     * @return 分类码对象
     */
    @GetMapping("/findOneSysUdc")
    SysUdcVO findOneSysUdc(
            @RequestParam("domainCode") @NotBlank(message = "领域码为空") String domainCode,
            @RequestParam("udcCode") @NotBlank(message = "UDC编码为空") String udcCode,
            @RequestParam("udcVal") @NotBlank(message = "UDC值为空") String udcVal);

    /**
     * 根据关键字段，返回对应的分类码
     *
     * @param domain  领域码
     * @param udc     分类码
     * @param valDesc
     * @return 分类码的值和值描述
     */
    @GetMapping("/listCodeCombosValLike")
    List<SysUdcComboVO> listCodeCombosValLike(@RequestParam("domain") String domain, @RequestParam("udc") String udc, @RequestParam("valDesc") String valDesc);

    /**
     * 根据关键字段，返回对应的分类码
     * 模糊查询itemGroup1 的值和code
     * 蒙华
     *
     * @param domain  领域码
     * @param udcCode
     * @param udc     以udc参数开头的
     * @return 模糊查询
     */
    @GetMapping("/listSubCodeLike")
    List<SysUdcComboVO> listSubCodeLike(@RequestParam("domain") String domain, @RequestParam("udcCode") String udcCode, @RequestParam("udc") String udc);

    /**
     * 根据关键字段，返回对应的分类码
     * 我模糊查询itemGroup1 的值和code
     * 蒙华
     *
     * @param domain 领域码
     * @param
     * @return 模糊查询
     */
    @GetMapping("/listCodeLike")
    List<SysUdcComboVO> listCodeLike(@RequestParam("domain") String domain, @RequestParam("udcCode") String udcCode, @RequestParam("udc") String udc);

    /**
     * 根据ID返回对应记录
     *
     * @param id 记录ID
     * @return 记录对象
     */
    @GetMapping("/findOneById")
    SysUdcVO findOneById(@RequestParam("id") Long id);

    /**
     * 获取用于下来选择的分类码
     *
     * @param domain 领域码
     * @param udc    分类码
     * @return 分类码的值和值描述
     */
    @GetMapping("/listCodeCombos")
    List<SysUdcComboVO> listCodeCombos(
            @RequestParam("domain") @NotBlank(message = "领域码为空") String domain,
            @RequestParam("udc") @NotBlank(message = "UDC编码为空") String udc);

    /**
     * 获取用于下来选择的分类码,udc的AOP翻译功能使用
     *
     * @param domain 领域码
     * @param udc    分类码
     * @return 分类码的值和值描述
     */
    @GetMapping("/listCodeCombosUdc")
    List<SysUdcComboVO> listCodeCombosUdc(
            @RequestParam("domain") @NotBlank(message = "领域码为空") String domain,
            @RequestParam("udc") @NotBlank(message = "UDC编码为空") String udc);

    /**
     * 获取分类码的Map对应列表
     *
     * @param domain 领域码
     * @param udc    分类码
     * @return 分类码的值和描述
     */
    @GetMapping("/getCodeMap")
    Map<String, String> getCodeMap(
            @RequestParam("domain") @NotBlank(message = "领域码为空") String domain,
            @RequestParam("udc") @NotBlank(message = "UDC编码为空") String udc);

    /**
     * 获取全部分类码的Map对应列表
     *
     * @return 分类码的值和描述
     */
    @GetMapping("/getCodeMapAll")
    Map<String, String> getCodeMapAll();

    /**
     * 组合UDC key 用于map 远程调用查询 udcDesc描述使用.
     * 参数:
     * 1 domainCode 领域code,
     * 2 udcCode udc编码
     * 3 valValue udc值
     * <p>
     * 组合采用&分割
     **/
    static String combinationUdcKey(String domainCode, String udcCode, String valValue) {
        String link = "&";
        return domainCode + link +
                udcCode + link +
                valValue;
    }

    @PostMapping("/findUdcByIds")
    List<SysUdcVO> findUdcByIds(@RequestBody List<Long> ids);
}
