package com.elitescloud.cloudt.system.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 数据权限类型.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/21
 */
public enum DataPermissionType {

    /**
     * 业务对象的权限规则（预留，暂未实现）
     */
    BUSINESS_OBJECT_RULE("业务对象"),
    /**
     * 业务对象操作的权限规则
     */
    BUSINESS_OPERATION_RULE("业务对象的操作"),
    /**
     * 菜单操作的权限规则
     */
    MENU_OPERATION_RULE("菜单的业务操作"),
    ;

    private final String description;

    private DataPermissionType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, DataPermissionType> ALL = Arrays.stream(DataPermissionType.values())
            .collect(Collectors.toMap(DataPermissionType::name, t -> t, (t1, t2) -> t1));

    /**
     * 转换对象
     *
     * @param value
     * @return
     */
    public static DataPermissionType fromValue(String value) {
        return ALL.get(value);
    }
}
