package com.elitescloud.cloudt.system.constant;

import com.elitescloud.boot.base.SafeEnum;

/**
 * 角色归属类型.
 *
 * @author Kaiser（wang shao）
 * 2022/10/13
 */
public class RoleType extends SafeEnum<RoleType> {
    private static final long serialVersionUID = 2642151856062071747L;

    public static final RoleType PLATFORM = new RoleType("platform", "平台角色");
    public static final RoleType TENANT = new RoleType("tenant", "租户角色");
    public static final RoleType TENANT_ORG = new RoleType("tenant_org", "租户组织角色");
    /**
     * 业务自定义角色
     */
    public static final RoleType CUSTOM = new RoleType("custom", "自定义角色");

    public RoleType() {
    }

    public RoleType(String value) {
        super(value);
    }

    public RoleType(String value, String description) {
        super(value, description);
    }
}
