package com.elitescloud.cloudt.system.dto;

import lombok.Getter;
import lombok.Setter;

/**
 * 字段权限规则
 *
 * @author chen.niu
 * @date 2023/1/31 23:18
 */
@Getter
@Setter
public class SysDpcRoleApiFieldsDTO extends BaseDataSecurityRuleDTO {
    private static final long serialVersionUID = -5228800510752566741L;

    /**
     * 规则ID
     */
    private Long id;

    /**
     * 字段名称
     */
    private String fieldName;

    /**
     * 是否可读
     */
    private Boolean readable;

    /**
     * 是否可写
     */
    private Boolean writeable;

    /**
     * api可见
     *
     * @deprecated 已弃用，改用{@link #readable}
     */
    @Deprecated(since = "3.3.0")
    private Boolean fieldApiVisible;

    /**
     * 表单可见
     *
     * @deprecated 已弃用，改用{@link #readable}
     */
    @Deprecated(since = "3.3.0")
    private Boolean fieldFormVisible;

    /**
     * 表单可编辑
     *
     * @deprecated 已弃用，改用{@link #writeable}
     */
    @Deprecated(since = "3.3.0")
    private Boolean fieldFormUpdate;
}
