package com.elitescloud.cloudt.system.dto;

import lombok.Data;
import org.springframework.http.HttpMethod;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * 三方接口调用日志.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/4
 */
@Data
public class ThirdApiLogDTO implements Serializable {
    private static final long serialVersionUID = -4191675697253884931L;

    /**
     * 请求业务域编码
     */
    @NotBlank(message = "应用编码为空")
    private String appCode;

    /**
     * 是否是Restful接口
     */
    @NotNull(message = "Restful标识为空")
    private Boolean restful;

    /**
     * 当前是否是服务端
     */
    @NotNull(message = "服务端标识为空")
    private Boolean server;

    /**
     * 服务端地址
     * <p>
     * 如果 {@link #server} = false，则 {@link #serverAddr} 不能为空，（不包含路由）
     */
    private String serverAddr;

    /**
     * 外部应用名称
     */
    private String thirdApp;

    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 业务数据key
     */
    private String businessKey;

    /**
     * 客户端ID
     */
    private String clientId;

    /**
     * 请求用户ID
     */
    private Long userId;

    /**
     * 请求用户
     */
    private String username;

    /**
     * 请求的接口地址
     * <p>
     * 包含路由
     */
    @NotBlank(message = "请求的接口为空")
    private String uri;

    /**
     * 请求方式
     */
    private HttpMethod reqMethod;

    /**
     * 请求的查询参数
     */
    private Map<String, String[]> reqQueryParams;

    /**
     * 请求体
     */
    private String reqBody;

    /**
     * 请求头
     */
    private Map<String, String[]> reqHeaders;

    /**
     * 是否请求成功
     */
    private Boolean reqSuccess;

    /**
     * 请求失败信息
     */
    private String reqFailMsg;

    /**
     * 请求时间
     */
    private LocalDateTime reqTime;

    /**
     * 请求者IP
     */
    private String reqIp;

    /**
     * 响应体
     */
    private String respBody;

    /**
     * 是否响应成功
     */
    private Boolean respSuccess;

    /**
     * 响应失败信息
     */
    private String respFailMsg;

    /**
     * 响应时间
     */
    private LocalDateTime respTime;

    /**
     * 是否需要自动重试
     */
    private Boolean needRetry;

    /**
     * 自动获取操作人的token
     */
    private Boolean detectedOperatorAuth;

    /**
     * 重试参数
     * <p>
     * 为空时则默认使用请求参数
     */
    private ThirdApiRetryParamDTO retryParam;
}
