package com.elitescloud.cloudt.system.dto.req;

import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 用户角色保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/10
 */
@Data
public class UserRoleSaveDTO implements Serializable {
    private static final long serialVersionUID = -7580295090054751243L;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户登录号
     * <p>
     * 与 {@link #userId} 至少一个不为空，userId不为空时，优先取值userId
     */
    private String username;

    /**
     * 角色ID
     */
    private Set<Long> roleIds;

    /**
     * 角色编码
     * <p>
     * {@link #roleIds} 不为空时，优先取值roleIds
     */
    private Set<String> roleCodes;
}
