package com.elitescloud.cloudt.system.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * 2020/7/19
 */
@Data
@ApiModel("权限查询结果对象，涵盖菜单、能力")
public class SysPermissionVO implements Serializable {

    private static final long serialVersionUID = -8608753467743271466L;

    /**
     * 权限ID
     */
    @ApiModelProperty("权限ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 权限代码
     */
    @ApiModelProperty(value = "权限代码")
    @NotBlank(message = "权限代码不能为空")
    private String code;

    /**
     * 权限名称
     */
    @ApiModelProperty(value = "权限名称")
    @NotBlank(message = "权限名称不能为空")
    private String name;

    /**
     * 权限类型: 1.菜单；0.按钮或API调用
     */
    @ApiModelProperty(value = "权限类型: 1.菜单；0.按钮或API调用")
    private Integer permType;

    /**
     * 父权限ID
     */
    @ApiModelProperty(value = "父权限ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long parentId;

    /**
     * 父权限名称"
     */
    @ApiModelProperty("父权限名称")
    private String parentName;

    /**
     * 权限层级路径
     */
    @ApiModelProperty(value = "权限层级路径")
    private String path;

    /**
     * 权限层级
     */
    @ApiModelProperty(value = "权限层级")
    private Integer permLevel;

    /**
     * 排列顺序
     */
    @ApiModelProperty("排列顺序")
    private Integer sortNo;

    /**
     * URL路径
     */
    @ApiModelProperty(value = "URL路径模式")
    @NotBlank(message = "URL路径不能为空")
    private String pattern;

    /**
     * URL的HTTP方法
     */
    @ApiModelProperty(value = "URL的HTTP方法[COM:HTTP_METH]")
    private String httpMethod;

    /**
     * 菜单是否隐藏
     */
    @ApiModelProperty(value = "菜单是否隐藏")
    private Boolean isHidden;

    /**
     * 菜单图标
     */
    @ApiModelProperty(value = "菜单图标")
    private String icon;

    /**
     * 菜单深度
     */
    @ApiModelProperty("菜单深度")
    private Integer menuDepth;
}
