package com.elitescloud.cloudt.revision.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.revision.vo.param.ComCurrRateQueryParamVO;
import com.elitescloud.cloudt.revision.vo.resp.ComCurrRateVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 汇率
 * </p>
 *
 * @author ssy
 * @date 2020/7/3
 */
@Deprecated(forRemoval = true, since = "0.3.0")
@Unicom(domain = InvokeDomain.SYSTEM, path = ComCurrRateService.URI)
public interface ComCurrRateService {
    String URI = Application.URI_PREFIX + "/deprecated" + "/curr/rate";

    /**
     * 货币汇率转换
     *
     * @param param
     * @return 汇率
     */
    @PostMapping(value = "/findRatio")
    Double findRatio(@RequestBody ComCurrRateQueryParamVO param);

    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    @PostMapping(value = "/search")
    PagingVO<ComCurrRateVO> search(@RequestBody ComCurrRateQueryParamVO queryParam);

    /**
     * 根据关键字段，返回对应的
     *
     * @param Id ID
     * @return 对象
     */
    @GetMapping(value = "/findIdOne")
    Optional<ComCurrRateVO> findIdOne(@RequestParam("Id") Long Id);

    /**
     * 创建
     *
     * @param objDo 对象
     */
    @PostMapping(value = "/createOne")
    Long createOne(@RequestBody ComCurrRateVO objDo);

    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    @PostMapping(value = "/findIdBatch")
    List<ComCurrRateVO> findIdBatch(@RequestBody List<Long> idList);

    /**
     * 创建
     *
     * @param List 对象集合
     */
    @PostMapping(value = "/createBatch")
    List<Long> createBatch(@RequestBody List<ComCurrRateVO> List);

    /**
     * 更新
     *
     * @param objDo 对象
     */
    @PostMapping(value = "/update")
    void update(@RequestBody ComCurrRateVO objDo);

    /**
     * 删除
     *
     * @param Id 对象
     */
    @GetMapping(value = "/deleteOne")
    void deleteOne(@RequestParam("Id") Long Id);

    /**
     * 删除
     *
     * @param idList 对象集合
     */
    @PostMapping(value = "/deleteBatch")
    void deleteBatch(@RequestBody List<Long> idList);


    /**
     * 更新删除标识
     *
     * @param id id
     */
    @GetMapping(value = "/updateDeleteFlag")
    void updateDeleteFlag(@RequestParam("id") Long id);
}
