package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

/**
 * 应用服务接口.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Validated
@Unicom(domain = InvokeDomain.SYSTEM, path = SysAppRpcService.URI)
public interface SysAppRpcService {
    String URI = Application.URI_PREFIX + "/app";

    /**
     * 获取所有的应用
     *
     * @return 应用
     */
    @GetMapping(value = "/all")
    ApiResult<List<CodeNameParam>> allApp();
}
