package com.elitescloud.cloudt.system.provider;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.system.dto.SysUserTerminalSaveDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
 * 用户终端服务.
 *
 * @author Kaiser（wang shao）
 * 2021/09/29
 */
@Validated
@Unicom(domain = InvokeDomain.SYSTEM, path = SysUserTerminalRpcService.URI)
public interface SysUserTerminalRpcService {
    String URI = Application.URI_PREFIX + "/userTerminal";

    /**
     * 保存用户与终端关联
     * <p>
     * 以参数中的终端作为用户的所有终端
     *
     * @param saveParam 保存参数
     * @return 用户ID
     */
    @PostMapping(value = "/save")
    ApiResult<Long> save(@RequestBody SysUserTerminalSaveDTO saveParam);

    /**
     * 新增终端绑定
     * <p>
     * 在用户已有的终端的基础上新增
     *
     * @param saveParam 保存参数
     * @return 用户ID
     */
    @PostMapping(value = "/saveForAdd")
    ApiResult<Long> saveForAdd(@RequestBody SysUserTerminalSaveDTO saveParam);

    /**
     * 减少终端绑定
     * <p>
     * 在用户已有的终端的基础上减少
     *
     * @param saveParam 保存参数
     * @return 用户ID
     */
    @PostMapping(value = "/saveForReduce")
    ApiResult<Long> saveForReduce(@RequestBody SysUserTerminalSaveDTO saveParam);

    /**
     * 获取用户关联的终端
     *
     * @param userId 用户ID
     * @return 关联的终端列表
     */
    @GetMapping(value = "/getByUser")
    ApiResult<List<Terminal>> getByUser(@RequestParam(value = "userId") @NotNull(message = "用户ID为空") Long userId);

    /**
     * 获取用户关联的终端
     *
     * @param username 用户名
     * @return 关联的终端列表
     */
    @GetMapping(value = "/getByUsername")
    ApiResult<List<Terminal>> getByUsername(@RequestParam(value = "username") @NotNull(message = "用户账号为空") String username);

    /**
     * 批量获取用户关联的终端
     *
     * @param userIds 用户ID
     * @return 用户及管理的终端列表
     */
    @PostMapping(value = "/getByUserIds")
    ApiResult<Map<Long, List<Terminal>>> getByUserIds(@RequestBody List<Long> userIds);
}
