package com.elitescloud.cloudt.system.provider.extend;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyRateQueryDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 汇率服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 3/15/2023
 */
@Validated
@Unicom(domain = InvokeDomain.SYSTEM, path = SysCurrencyRateRpcService.URI)
public interface SysCurrencyRateRpcService {
    String URI = Application.URI_PREFIX + "/currencyRate";

    /**
     * 获取汇率
     *
     * @param queryDTO 查询参数
     * @return 汇率值
     */
    @PostMapping(value = "/findRatio")
    ApiResult<Double> findRatio(@RequestBody @Valid SysCurrencyRateQueryDTO queryDTO);
}
