package com.elitescloud.cloudt.system.provider.extend;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
@Validated
@Unicom(domain = InvokeDomain.SYSTEM, path = SysThirdPartyAccountRpcService.URI)
public interface SysThirdPartyAccountRpcService {
    String URI = Application.URI_PREFIX + "/third_party";

    /**
     * 根据应用账号查询租户ID
     *
     * @param account 应用账号，如微信的AppID
     * @return 租户ID
     */
    @GetMapping(value = "/getTenantIdByAccount")
    ApiResult<Long> getTenantIdByAccount(@NotBlank(message = "应用账号为空") @RequestParam(name = "account") String account);
}
