package com.elitescloud.cloudt.system.provider.org;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 员工组服务.
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
@Validated
@Unicom(domain = InvokeDomain.SYSTEM, path = EmployeeGroupRpcService.URI)
public interface EmployeeGroupRpcService {
    String URI = Application.URI_PREFIX + "/emp_group";

    /**
     * 根据员工组查询用户ID
     * <p>
     * 查询员工组下的员工的用户ID
     *
     * @param groupCode 员工组编号
     * @return 用户ID列表
     */
    @GetMapping(value = "/getUserIdsByGroupCode")
    ApiResult<List<Long>> getUserIdsByGroupCode(@NotBlank(message = "员工组编号为空") @RequestParam(value = "groupCode") String groupCode);

    /**
     * 根据员工组编号查询用户ID
     *
     * @param groupCodes 员工组编号
     * @return 员工组件与用户ID的map
     */
    @PostMapping(value = "/queryUserIdsByGroupCodes")
    ApiResult<Map<String, List<Long>>> queryUserIdsByGroupCodes(@NotEmpty(message = "员工组编码为空") @RequestBody Set<String> groupCodes);
}
