create table IF NOT EXISTS  sync_http_group
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    name               varchar(255) not null,
    icon               varchar(255) not null,
    code               varchar(255) null,
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id'
    );

create table IF NOT EXISTS  sys_biz_constraint
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    data_role_code     varchar(255) null comment '数据角色编码',
    data_role_name     varchar(255) null comment '数据角色名称',
    domain_code        varchar(255) null comment '领域编码',
    domain_name        varchar(255) null comment '领域名称',
    table_code         varchar(255) null comment '表编码',
    table_name         varchar(255) null comment '表名称',
    field_code         varchar(255) null comment '表字段编码',
    field_caption      varchar(255) null comment '字段名称',
    field_type         varchar(255) null comment '字段类型',
    udc_domain_code    varchar(255) null comment 'UDC的Domain Code',
    udc_code           varchar(255) null comment 'UDC的UDC Code',
    default_value      varchar(255) null comment '默认值',
    compare_op_code    varchar(255) null comment '比较符编码',
    compare_op_name    varchar(255) null comment '比较符名称',
    constraint_values  varchar(255) null comment '约束值, 多值采用逗号分隔',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    field_udc_type     varchar(255) null comment '逻辑UDC字段类型META:FLDTYPE',
    meta_column_id     bigint       null comment '元数据列的记录ID'
    )
    comment '业务数据权限约束';

create table IF NOT EXISTS  sys_butable
(
    id           bigint auto_increment comment '主键'
    primary key,
    butable_name varchar(128) null comment '表名称',
    use_null     int(1)       null comment '是否可以使用空值 1:可以 0:不可以',
    delete_flag  int(1)       null comment '逻辑删除，0：未删除，1：已删除'
    );

create table IF NOT EXISTS  sys_data_role
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    code               varchar(40)  not null comment '数据角色代码',
    name               varchar(40)  not null comment '数据角色名称',
    advanced_enable    int          not null comment '是否取用高级授权',
    enabled            int          null comment '是否启用',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    business_enable    int          null,
    constraint UK_cem7cq6iwip27be1ik1724rtq
    unique (code)
    )
    comment '系统数据角色表';

create index create_user_id_index
    on IF NOT EXISTS  sys_data_role (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_data_role (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_data_role (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_data_role (sec_user_id);

create table IF NOT EXISTS  sys_data_role_auth
(
    id                   bigint       not null comment '记录唯一ID'
    primary key,
    data_role_id         bigint       null comment '关联的数据角色ID',
    is_basic             int          null comment '是否基础数据授权：1 是，0 否',
    permission_id        bigint       null comment '高级授权应用ID',
    permission_code      varchar(255) null comment '高级授权应用Code',
    is_permit_all        int          not null comment '是否全部授权全部数据',
    emp_auth_enable      int          null comment '是否启用员工授权',
    emp_auth_scope       varchar(40)  null comment '员工数据权限授权范围',
    emp_customize_enable int          null comment '员工是否启用自定义授权',
    bu_auth_enable       int          null comment '是否启用组织授权',
    bu_auth_scope        varchar(40)  null comment '组织数据权限授权范围',
    bu_customize_enable  int          null comment '组织是否启用自定义授权',
    tenant_id            bigint       null comment '租户ID',
    remark               varchar(255) null comment '备注',
    create_user_id       bigint       null comment '记录创建者ID',
    creator              varchar(255) null comment '记录创建者',
    create_time          datetime(6)  null comment '记录创建时间',
    modify_user_id       bigint       null comment '记录最后更新者ID',
    updater              varchar(255) null comment '记录最后更新者',
    modify_time          datetime(6)  null comment '记录最后更新时间',
    delete_flag          int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version   int          null comment '锁版本',
    sec_bu_id            bigint       null comment 'sec_bu_id',
    sec_user_id          bigint       null comment 'sec_user_id',
    sec_ou_id            bigint       null comment 'sec_ou_id',
    ou_auth_enable       int          null comment '是否启用公司授权',
    ou_auth_scope        varchar(40)  null comment '公司数据权限授权范围',
    ou_customize_enable  int          null comment '公司是否启用自定义授权'
    )
    comment '系统数据角色授权表';

create index create_user_id_index
    on IF NOT EXISTS  sys_data_role_auth (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_data_role_auth (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_data_role_auth (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_data_role_auth (sec_user_id);

create table IF NOT EXISTS  sys_data_role_auth_customize
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    data_role_auth_id  bigint       null comment '数据角色授权信息ID',
    customize_type     varchar(40)  null comment '自定义类型：人员还是组织',
    sec_id             bigint       null comment '自定义授权数据ID',
    sec_code           varchar(40)  null comment '自定义授权数据CODE',
    sec_name           varchar(40)  null comment '自定义授权数据名称',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id'
    )
    comment '系统数据角色自定义授权表';

create index create_user_id_index
    on IF NOT EXISTS  sys_data_role_auth_customize (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_data_role_auth_customize (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_data_role_auth_customize (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_data_role_auth_customize (sec_user_id);

create table IF NOT EXISTS  sys_database_source
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    dbs_name           varchar(64)  not null comment '数据源名称',
    dbs_driver_class   varchar(64)  not null comment '驱动类',
    dbs_url            varchar(256) not null comment '连接地址',
    dbs_username       varchar(64)  not null comment '驱动类',
    dbs_password       varchar(64)  not null comment '驱动类',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    constraint UK_5mh7yibgt1q5tlovw1mt6isw1
    unique (dbs_url),
    constraint UK_69xvjg1vba9gyinypft4tywrx
    unique (dbs_driver_class),
    constraint UK_9d72e74h16s1902atl61lq1gw
    unique (dbs_username),
    constraint UK_q561tgabwwkr4eshxubn5icba
    unique (dbs_password),
    constraint UK_qrmqns00nx8p2jgk46jk79ysl
    unique (dbs_name)
    )
    comment '数据源表';

create table IF NOT EXISTS  sys_dp
(
    id                 bigint auto_increment comment '记录唯一ID'
    primary key,
    domain_code        varchar(64)  null comment '领域编号',
    domain_code_name   varchar(64)  null comment '领域名称',
    table_code         varchar(64)  null comment '表名编码',
    table_name         varchar(64)  null comment '表名中文',
    table_desc         varchar(64)  null comment '表说明',
    dp_type            varchar(64)  null comment '数据权限类型',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本'
    )
    comment '数据权限开关';

create index create_user_id_index
    on IF NOT EXISTS  sys_dp (create_user_id);

create table IF NOT EXISTS  sys_dp_role
(
    id                 bigint auto_increment comment '记录唯一ID'
    primary key,
    dp_role_code       varchar(64)   null comment '数据权限编码',
    dp_role_name       varchar(64)   null comment '数据权限名称',
    bu_tree_id         bigint        null comment '组织树ID',
    enable             int default 0 null comment '是否启用',
    tenant_id          bigint        null comment '租户ID',
    remark             varchar(255)  null comment '备注',
    create_user_id     bigint        null comment '记录创建者ID',
    creator            varchar(255)  null comment '记录创建者',
    create_time        datetime(6)   null comment '记录创建时间',
    modify_user_id     bigint        null comment '记录最后更新者ID',
    updater            varchar(255)  null comment '记录最后更新者',
    modify_time        datetime(6)   null comment '记录最后更新时间',
    delete_flag        int           not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int           null comment '锁版本'
    )
    comment '数据权限表';

create index create_user_id_index
    on IF NOT EXISTS  sys_dp_role (create_user_id);

create table IF NOT EXISTS  sys_dp_role_power
(
    id                 bigint auto_increment comment '记录唯一ID'
    primary key,
    dp_role_code       varchar(64)  null comment '数据权限编码',
    bu_tree_id         bigint       null comment '组织树ID',
    bu_id              bigint       null comment '组织ID',
    bu_tree_d_id       bigint       null comment '组织树节点ID',
    ac_type            varchar(16)  null comment '访问控制类型 [UDC]USR:AC_TYPE',
    inherit_type       varchar(16)  null comment '继承类型 [UDC]USR:INHERIT_TYPE',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本'
    )
    comment '数据权限明细表';

create index create_user_id_index
    on IF NOT EXISTS  sys_dp_role_power (create_user_id);

create table IF NOT EXISTS  sys_flow_role
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    code               varchar(16)  not null comment '角色代码',
    name               varchar(32)  not null comment '角色名称',
    enabled            int          null comment '是否启用',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    constraint UK_k7iim1lyhuyr06xn6jdj8vei1
    unique (code)
    )
    comment '流程角色表';

create table IF NOT EXISTS  sys_front_config
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    role_id            bigint       null comment '绑定的应用角色ID',
    permission_id      bigint       null comment '绑定的权限ID',
    config_code        varchar(40)  null comment '配置编号',
    config_context     longtext     null comment '配置内容',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id'
    )
    comment '前端表单，表格动态配置';

create index idx_config_code
    on IF NOT EXISTS  sys_front_config (config_code);

create table IF NOT EXISTS  sys_log_login
(
    id                 bigint        not null comment '记录唯一ID'
    primary key,
    sys_user_id        int           null,
    time_login         timestamp     null,
    ip_inner           varchar(40)   null,
    ip_outer           varchar(40)   null,
    address            varchar(40)   null comment '地区 地区',
    browser            varchar(40)   null comment '浏览器 浏览器',
    user_agent         varchar(2000) null,
    create_user_name   varchar(40)   null,
    modify_user_name   varchar(40)   null,
    tenant_id          bigint        null comment '租户ID',
    remark             varchar(255)  null comment '备注',
    create_user_id     bigint        null comment '记录创建者ID',
    creator            varchar(255)  null comment '记录创建者',
    create_time        datetime(6)   null comment '记录创建时间',
    modify_user_id     bigint        null comment '记录最后更新者ID',
    updater            varchar(255)  null comment '记录最后更新者',
    modify_time        datetime(6)   null comment '记录最后更新时间',
    delete_flag        int           null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int           null comment '锁版本'
    )
    comment '登录日志 登录日志';

create index create_user_id_index
    on IF NOT EXISTS  sys_log_login (create_user_id);

create table IF NOT EXISTS  sys_next_number
(
    id                 bigint auto_increment comment '记录唯一ID'
    primary key,
    code               varchar(255) not null comment '下一编号代码',
    name               varchar(255) not null comment '下一编号名称',
    number_class       varchar(255) null comment '下一编号分类',
    step               int          null comment '下一编号步长',
    next_number        bigint       null comment '下一编号取值',
    nn_period          varchar(255) null comment '下一编号周期',
    nn_time            datetime(6)  null comment '发号时间',
    version            int          null comment '乐观锁标记',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    constraint UK_s6xdfqu3p37tc3a6gpsc23mq8
    unique (code)
    )
    comment '取号下一编号表';

create index create_user_id_index
    on IF NOT EXISTS  sys_next_number (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_next_number (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_next_number (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_next_number (sec_user_id);

create table IF NOT EXISTS  sys_next_number_test
(
    id                 bigint default 0 not null comment '记录唯一ID',
    code               varchar(255)     not null comment '下一编号代码',
    name               varchar(255)     not null comment '下一编号名称',
    number_class       varchar(255)     null comment '下一编号分类',
    step               int              null comment '下一编号步长',
    next_number        bigint           null comment '下一编号取值',
    nn_period          varchar(255)     null comment '下一编号周期',
    nn_time            datetime(6)      null comment '发号时间',
    version            int              null comment '乐观锁标记',
    tenant_id          bigint           null comment '租户ID',
    remark             varchar(255)     null comment '备注',
    create_user_id     bigint           null comment '记录创建者ID',
    creator            varchar(255)     null comment '记录创建者',
    create_time        datetime(6)      null comment '记录创建时间',
    modify_user_id     bigint           null comment '记录最后更新者ID',
    updater            varchar(255)     null comment '记录最后更新者',
    modify_time        datetime(6)      null comment '记录最后更新时间',
    delete_flag        int              null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int              null comment '锁版本'
    );

create index create_user_id_index
    on IF NOT EXISTS  sys_next_number_test (create_user_id);

create table IF NOT EXISTS  sys_number_rule
(
    id                 bigint auto_increment comment '记录唯一ID'
    primary key,
    rule_code          varchar(255) not null comment '规则编号',
    rule_name          varchar(64)  null comment '规则名称',
    rule_class         varchar(32)  null comment '规则分类码：sys:numrulcls',
    sample_code        varchar(255) null comment '取号示例',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    constraint UK_3904pugpu38vqwlg4aussvgr1
    unique (rule_code)
    )
    comment '发号器规则';

create index create_user_id_index
    on IF NOT EXISTS  sys_number_rule (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_number_rule (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_number_rule (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_number_rule (sec_user_id);

create table IF NOT EXISTS  sys_number_ruledtl
(
    id                 bigint auto_increment comment '记录唯一ID'
    primary key,
    rule_id            bigint       null comment '发号器规则ID',
    seq                int          null comment '排序号',
    number_type        varchar(255) null comment '取号类型：sys:numbertype',
    number_pattern     varchar(255) null comment '取号模式，根据取号类型填写对应的固定字符串、日期格式化字符串、自增序号码',
    nn_len             int          null comment '自增序号宽度，默认左补零',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id'
    )
    comment '发号器规则明细';

create index create_user_id_index
    on IF NOT EXISTS  sys_number_ruledtl (create_user_id);

create index idx_sys_number_ruledtl_rule_id
    on IF NOT EXISTS  sys_number_ruledtl (rule_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_number_ruledtl (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_number_ruledtl (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_number_ruledtl (sec_user_id);

create table IF NOT EXISTS  sys_oper_exce_log
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    requ_param         varchar(500) null,
    exce_name          varchar(200) null,
    exce_message       varchar(500) null,
    oper_uri           varchar(200) null,
    oper_ip            varchar(200) null,
    oper_method        varchar(200) null,
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本'
    )
    comment '操作异常表';

create index create_user_id_index
    on IF NOT EXISTS  sys_oper_exce_log (create_user_id);

create table IF NOT EXISTS  sys_oper_log
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    requ_param         varchar(500) null,
    reps_param         varchar(500) null,
    oper_uri           varchar(200) null,
    oper_ip            varchar(200) null,
    oper_method        varchar(200) null,
    oper_modul         varchar(50)  null,
    oper_type          varchar(50)  null,
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本'
    )
    comment '操作日志表';

create index create_user_id_index
    on IF NOT EXISTS  sys_oper_log (create_user_id);

create table IF NOT EXISTS  sys_permission
(
    id                 bigint auto_increment comment '账号唯一ID'
    primary key,
    code               varchar(128) charset utf8 not null comment '权限代码',
    name               varchar(64)               not null comment '权限名称',
    perm_type          int                       null comment '权限类型',
    parent_id          bigint                    null comment '父权限ID',
    path               varchar(255)              null comment '权限层级路径',
    perm_level         int                       null comment '权限层级',
    sort_no            int                       null comment '排列顺序',
    pattern            varchar(255)              null comment 'URL路径模式',
    http_method        varchar(32)               null comment 'URL的HTTP方法[COM:HTTP_METH]',
    tenant_id          bigint                    null comment '租户ID',
    remark             varchar(255)              null comment '备注',
    create_user_id     bigint                    null comment '记录创建者ID',
    create_time        datetime(6)               null comment '记录创建时间',
    modify_user_id     bigint                    null comment '记录最后更新者ID',
    modify_time        datetime(6)               null comment '记录最后更新时间',
    delete_flag        int                       null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int                       null comment '版本',
    creator            varchar(255)              null comment '记录创建者',
    updater            varchar(255)              null comment '记录最后更新者',
    icon               varchar(255)              null comment '菜单图标',
    is_hidden          int                       null comment '菜单是否隐藏',
    sec_bu_id          bigint                    null comment 'sec_bu_id',
    sec_user_id        bigint                    null comment 'sec_user_id',
    sec_ou_id          bigint                    null comment 'sec_ou_id'
    )
    comment '系统权限表，包括URL、操作';

create index create_user_id_index
    on IF NOT EXISTS  sys_permission (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_permission (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_permission (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_permission (sec_user_id);

create table IF NOT EXISTS  sys_resources
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    task_id            bigint       not null comment '任务id',
    code               varchar(128) not null comment '资源代码',
    name               varchar(16)  not null comment '资源名称',
    perm_type          int          null comment '资源类型',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    constraint UK_pperopjlwwkh8gd2a0krwcua3
    unique (code)
    )
    comment '系统资源表';

create table IF NOT EXISTS  sys_role
(
    id                 bigint auto_increment comment '账号唯一ID'
    primary key,
    code               varchar(16)  not null comment '角色代码',
    name               varchar(32)  not null comment '角色名称',
    enabled            int          null comment '是否启用',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '版本',
    creator            varchar(255) null comment '记录创建者',
    updater            varchar(255) null comment '记录最后更新者',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    tenant_name        varchar(64)  null comment '所属租户名称'
    )
    comment '系统角色表';

create index UK_plpigyqwsqfn7mn66npgf9ftp
    on IF NOT EXISTS  sys_role (code);

create index create_user_id_index
    on IF NOT EXISTS  sys_role (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_role (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_role (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_role (sec_user_id);

create table IF NOT EXISTS  sys_role_copy1
(
    id                 bigint auto_increment comment '账号唯一ID'
    primary key,
    code               varchar(16)  not null comment '角色代码',
    name               varchar(32)  not null comment '角色名称',
    enabled            int          null comment '是否启用',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '版本',
    creator            varchar(255) null comment '记录创建者',
    updater            varchar(255) null comment '记录最后更新者',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    constraint UK_plpigyqwsqfn7mn66npgf9ftp
    unique (code)
    )
    comment '系统角色表';

create index create_user_id_index
    on IF NOT EXISTS  sys_role_copy1 (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_role_copy1 (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_role_copy1 (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_role_copy1 (sec_user_id);

create table IF NOT EXISTS  sys_role_ou
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    ou_id              bigint       null comment '公司ID',
    ou_name            varchar(32)  not null comment '公司名称',
    role_id            bigint       null comment '角色ID',
    role_name          varchar(32)  not null comment '角色名称',
    role_type          int          not null comment '角色类型：0：应用角色，1 数据角色  目前仅支持数据角色',
    username           varchar(32)  not null comment '用户账号名称',
    last_name          varchar(256) null comment '用户姓氏',
    first_name         varchar(256) null comment '用户名称',
    user_id            bigint       null comment '用户Id',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    constraint UK_ajal0xja8q14kapqpgxq9hynj
    unique (username)
    )
    comment '系统角色与公司表';

create table IF NOT EXISTS  sys_role_permission
(
    id                 bigint       not null comment '账号唯一ID'
    primary key,
    role_id            bigint       null comment '角色ID',
    permission_id      bigint       null comment '权限ID',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '版本',
    creator            varchar(255) null comment '记录创建者',
    updater            varchar(255) null comment '记录最后更新者',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id'
    )
    comment '角色权限关联表';

create index create_user_id_index
    on IF NOT EXISTS  sys_role_permission (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_role_permission (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_role_permission (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_role_permission (sec_user_id);

create table IF NOT EXISTS  sys_role_resources
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    role_id            bigint       null comment '角色ID',
    resources_id       bigint       null comment '资源ID',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id'
    )
    comment '角色资源关联表';

create table IF NOT EXISTS  sys_setting
(
    id                 bigint auto_increment comment '记录唯一ID'
    primary key,
    setting_no         varchar(40)  null comment '设置编号',
    setting_name       varchar(40)  null comment '设置名',
    setting_type       varchar(40)  null comment '设置类型',
    setting_type2      varchar(40)  null comment '设置类型2',
    setting_type3      varchar(40)  null comment '设置类型3',
    setting_status     varchar(40)  null comment '设置状态',
    setting_desc       varchar(500) null comment '设置描述',
    setting_val        varchar(500) null comment '设置值',
    def_val            varchar(100) null comment '默认值',
    sort_no            int          null comment '排序号',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    email              varchar(32)  null comment '设置类型3',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id'
    )
    comment '设置项';

create index create_user_id_index
    on IF NOT EXISTS  sys_setting (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_setting (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_setting (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_setting (sec_user_id);

create table IF NOT EXISTS  sys_tenant
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    tenant_name        varchar(32)  not null comment '租户名称',
    database_source_id bigint       null comment '租户数据隔离数据源',
    tenant_isolation   varchar(32)  not null comment '租户数据隔离',
    tenant_domain      varchar(256) not null comment '域名地址',
    linkman            varchar(64)  not null comment '联系人',
    contact_number     varchar(64)  not null comment '联系电话',
    address            varchar(64)  not null comment '联系地址',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    constraint UK_4ga19rxk91slo7uxf9r08mvp3
    unique (address),
    constraint UK_e1urmrnxpt8m75ufr7df39w7v
    unique (linkman),
    constraint UK_hkxi0aymh1v7ymxu7h1svct2n
    unique (tenant_name),
    constraint UK_k7onxiyag8s9icompjl9yoakm
    unique (tenant_isolation),
    constraint UK_niyctlwy6hr2hdhpcctqos0xf
    unique (contact_number),
    constraint UK_pm1x0953bvt52g82wll8m47p5
    unique (tenant_domain)
    )
    comment '平台租户表';

create table IF NOT EXISTS  sys_udc
(
    id                 bigint auto_increment comment '记录唯一ID'
    primary key,
    domain_code        varchar(32)  not null comment '领域码',
    udc_code           varchar(32)  not null comment 'UDC码',
    udc_name           varchar(64)  null comment 'UDC码名称',
    udc_val            varchar(32)  not null comment 'UDC值',
    val_desc           varchar(64)  not null comment '值描述',
    val_sort_no        int          null comment '排序号',
    hd_flag            int          null comment '硬编码',
    dp_flag            int          null comment '是否开启数据权限',
    es1                varchar(32)  null comment '扩展字段1-特殊处理',
    es2                varchar(32)  null comment '扩展字段2',
    es3                varchar(32)  null comment '扩展字段3',
    es4                varchar(32)  null comment '扩展字段4',
    es5                varchar(32)  null comment '扩展字段5',
    es6                varchar(32)  null comment '扩展字段6',
    es7                varchar(32)  null comment '扩展字段7',
    es8                varchar(32)  null comment '扩展字段8',
    ef1                double       null comment '扩展浮点1',
    ef2                double       null comment '扩展浮点2',
    ef3                double       null comment '扩展浮点3',
    ef4                double       null comment '扩展浮点4',
    ei1                int          null comment '扩展整数1',
    ei2                int          null comment '扩展整数2',
    ei3                int          null comment '扩展整数3',
    ei4                int          null comment '扩展整数4',
    ed1                datetime(6)  null comment '扩展日期1',
    ed2                datetime(6)  null comment '扩展日期2',
    ed3                datetime(6)  null comment '扩展日期3',
    ed4                datetime(6)  null comment '扩展日期4',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    constraint uk_domain_code_val
    unique (domain_code, udc_code, udc_val)
    )
    comment '分类码表';

create table IF NOT EXISTS  sys_udc_dev
(
    id                 bigint default 0 not null comment '记录唯一ID',
    domain_code        varchar(32)      not null comment '领域码',
    udc_code           varchar(32)      not null comment 'UDC码',
    udc_name           varchar(64)      null comment 'UDC码名称',
    udc_val            varchar(32)      not null comment 'UDC值',
    val_desc           varchar(64)      not null comment '值描述',
    val_sort_no        int              null comment '排序号',
    hd_flag            int              null comment '硬编码',
    dp_flag            int              null comment '是否开启数据权限',
    es1                varchar(32)      null comment '扩展字段1-特殊处理',
    es2                varchar(32)      null comment '扩展字段2',
    es3                varchar(32)      null comment '扩展字段3',
    es4                varchar(32)      null comment '扩展字段4',
    es5                varchar(32)      null comment '扩展字段5',
    es6                varchar(32)      null comment '扩展字段6',
    es7                varchar(32)      null comment '扩展字段7',
    es8                varchar(32)      null comment '扩展字段8',
    ef1                double           null comment '扩展浮点1',
    ef2                double           null comment '扩展浮点2',
    ef3                double           null comment '扩展浮点3',
    ef4                double           null comment '扩展浮点4',
    ei1                int              null comment '扩展整数1',
    ei2                int              null comment '扩展整数2',
    ei3                int              null comment '扩展整数3',
    ei4                int              null comment '扩展整数4',
    ed1                datetime(6)      null comment '扩展日期1',
    ed2                datetime(6)      null comment '扩展日期2',
    ed3                datetime(6)      null comment '扩展日期3',
    ed4                datetime(6)      null comment '扩展日期4',
    tenant_id          bigint           null comment '租户ID',
    remark             varchar(255)     null comment '备注',
    create_user_id     bigint           null comment '记录创建者ID',
    creator            varchar(255)     null comment '记录创建者',
    create_time        datetime(6)      null comment '记录创建时间',
    modify_user_id     bigint           null comment '记录最后更新者ID',
    updater            varchar(255)     null comment '记录最后更新者',
    modify_time        datetime(6)      null comment '记录最后更新时间',
    delete_flag        int              null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int              null comment '锁版本',
    sec_bu_id          bigint           null comment 'sec_bu_id',
    sec_user_id        bigint           null comment 'sec_user_id',
    sec_ou_id          bigint           null comment 'sec_ou_id'
    );

create index create_user_id_index
    on IF NOT EXISTS  sys_udc_dev (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_udc_dev (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_udc_dev (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_udc_dev (sec_user_id);

create table IF NOT EXISTS  sys_user
(
    id                 bigint auto_increment comment '记录唯一ID'
    primary key,
    username           varchar(32)   not null comment '用户账号名称',
    last_name          varchar(256)  null comment '用户姓氏',
    first_name         varchar(256)  null comment '用户名称',
    mobile             varchar(16)   null comment '用户手机号码',
    email              varchar(32)   null comment '用户邮箱地址',
    password           varchar(128)  not null comment '用户账号密码-hashed',
    source_type        varchar(32)   null comment '账号来源, sys： 系统创建；wec：微信创建；oth：其他方式',
    enabled            int           null comment '是否启用',
    trans_flag         int default 0 null comment '是否同步 0 未同步 1 已同步',
    tenant_id          bigint        null comment '租户ID',
    remark             varchar(255)  null comment '备注',
    create_user_id     bigint        null comment '记录创建者ID',
    creator            varchar(255)  null comment '记录创建者',
    create_time        datetime(6)   null comment '记录创建时间',
    modify_user_id     bigint        null comment '记录最后更新者ID',
    updater            varchar(255)  null comment '记录最后更新者',
    modify_time        datetime(6)   null comment '记录最后更新时间',
    delete_flag        int           null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int           null comment '锁版本',
    sec_bu_id          bigint        null comment 'sec_bu_id',
    sec_user_id        bigint        null comment 'sec_user_id',
    sec_ou_id          bigint        null comment 'sec_ou_id',
    need_reset         int           null comment '密码是否需要重新设置',
    wx_openid          varchar(128)  null comment '微信poenid',
    ou_id              bigint        null comment '用户所属公司ID',
    ou_code            varchar(40)   null comment '用户所属公司编号',
    ou_name            varchar(40)   null comment '用户所属公司名称',
    bu_id              bigint        null comment '用户所属组织ID',
    avatar_url         varchar(2048) null comment '用户头像地址，可直接访问，如微信头像地址等',
    avatar_code        varchar(32)   null comment '用户头像在文件服务器中的标识',
    full_name          varchar(40)   null comment '用户姓名',
    user_type          varchar(40)   null comment '用户类型',
    tenant_name        varchar(65)   null comment '所属租户名称',
    constraint UK_51bvuyvihefoh4kp5syh2jpi4
    unique (username)
    )
    comment '系统用户账号表';

create index create_user_id_index
    on IF NOT EXISTS  sys_user (create_user_id);

create index idx_sys_user_mobile
    on IF NOT EXISTS  sys_user (mobile);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_user (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_user (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_user (sec_user_id);

create table IF NOT EXISTS  sys_user_data_role
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    user_id            bigint       null comment '账号ID',
    role_id            bigint       null comment '数据角色ID',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id'
    )
    comment '用户数据角色关联表';

create index create_user_id_index
    on IF NOT EXISTS  sys_user_data_role (create_user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_user_data_role (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_user_data_role (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_user_data_role (sec_user_id);

create table IF NOT EXISTS  sys_user_flow_role
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    user_id            bigint       null comment '账号ID',
    role_id            bigint       null comment '数据角色ID',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id'
    )
    comment '用户流程角色关联表';

create table IF NOT EXISTS  sys_user_proxy
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    user_id            bigint       null comment '被代理人id',
    username           varchar(32)  not null comment '被代理人用户账号名称',
    mobile             varchar(16)  null comment '被代理人用户手机号码',
    email              varchar(32)  null comment '被代理人用户邮箱地址',
    ou_id              bigint       null comment '被代理人用户所属公司ID',
    ou_code            varchar(40)  null comment '被代理人用户所属公司编号',
    ou_name            varchar(40)  null comment '被代理人用户所属公司名称',
    bu_id              bigint       null comment '被代理人用户所属组织ID',
    proxy_user_id      bigint       null comment '代理人id',
    proxy_username     varchar(32)  not null comment '代理人用户账号名称',
    proxy_mobile       varchar(16)  null comment '代理人用户手机号码',
    proxy_email        varchar(32)  null comment '代理人用户邮箱地址',
    proxy_ou_id        bigint       null comment '代理人用户所属公司ID',
    proxy_ou_code      varchar(40)  null comment '代理人用户所属公司编号',
    proxy_ou_name      varchar(40)  null comment '代理人用户所属公司名称',
    proxy_bu_id        bigint       null comment '代理人用户所属组织ID',
    open_flag          int          null comment '是否开启-0：开启，1关闭',
    effect_start_time  datetime(6)  null comment '代理生效开始时间',
    effect_end_time    datetime(6)  null comment '代理生效结束时间',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id',
    constraint UK_al4cbi2jpu3dc3128lomq2s88
    unique (proxy_username),
    constraint UK_asmyoj2xbixiyvpymex71uihg
    unique (username)
    )
    comment '被代理用户与代理用户关系表';

create table IF NOT EXISTS  sys_user_role
(
    id                 bigint auto_increment comment '账号唯一ID'
    primary key,
    user_id            bigint       null comment '用户ID',
    role_id            bigint       null comment '角色ID',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '版本',
    creator            varchar(255) null comment '记录创建者',
    updater            varchar(255) null comment '记录最后更新者',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id'
    )
    comment '用户角色关联表';

create index create_user_id_index
    on IF NOT EXISTS  sys_user_role (create_user_id);

create index idx_sys_user_role_role_id
    on IF NOT EXISTS  sys_user_role (role_id);

create index idx_sys_user_role_user_id
    on IF NOT EXISTS  sys_user_role (user_id);

create index sec_bu_id_index
    on IF NOT EXISTS  sys_user_role (sec_bu_id);

create index sec_ou_id_index
    on IF NOT EXISTS  sys_user_role (sec_ou_id);

create index sec_user_id_index
    on IF NOT EXISTS  sys_user_role (sec_user_id);

create table IF NOT EXISTS  sys_user_terminal
(
    id                 bigint       not null comment '记录唯一ID'
    primary key,
    user_id            bigint       not null comment '用户ID，sys_user.id',
    terminal_code      varchar(64)  not null comment '终端编码，Terminal枚举类',
    time_bind          datetime     null comment '绑定时间',
    tenant_id          bigint       null comment '租户ID',
    remark             varchar(255) null comment '备注',
    create_user_id     bigint       null comment '记录创建者ID',
    creator            varchar(255) null comment '记录创建者',
    create_time        datetime(6)  null comment '记录创建时间',
    modify_user_id     bigint       null comment '记录最后更新者ID',
    updater            varchar(255) null comment '记录最后更新者',
    modify_time        datetime(6)  null comment '记录最后更新时间',
    delete_flag        int          not null comment '逻辑删除，0：未删除，1：已删除',
    audit_data_version int          null comment '锁版本',
    sec_bu_id          bigint       null comment 'sec_bu_id',
    sec_user_id        bigint       null comment 'sec_user_id',
    sec_ou_id          bigint       null comment 'sec_ou_id'
    )
    comment '用户与终端的关联';

create index idx_sys_user_terminal_user
    on IF NOT EXISTS  sys_user_terminal (user_id);

