package com.elitescloud.cloudt.system.spi;

import com.elitescloud.cloudt.system.param.SysUserNewParam;

/**
 * 用户管理的扩展.
 *
 * @author Kaiser（wang shao）
 * 2022/4/6
 */
public interface SysUserServiceSpi {

    /**
     * 服务名称
     *
     * @return 服务名称
     */
    String getServiceName();

    /**
     * 用户新增前的处理
     *
     * @param userNewParam
     */
    void beforeUserAdd(SysUserNewParam userNewParam);

    /**
     * 用户新增后的回调
     *
     * @param sysUserId 用户ID
     */
    void afterUserAdd(SysUserNewParam userNewParam, Long sysUserId);

    /**
     * 用户修改后的回调
     *
     * @param sysUserId 用户ID
     */
    void afterUserUpdate(Long sysUserId);

    /**
     * 用户删除后的回调
     *
     * @param sysUserId 用户ID
     */
    void afterUserDelete(Long sysUserId);
}
