/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.provider;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.param.SysUserNewParam;
import com.elitescloud.cloudt.system.spi.SysUserServiceSpi;
import com.elitescloud.cloudt.tenant.TenantClient;
import com.elitescloud.cloudt.tenant.service.SysTenantMngService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SysUserServiceProvider
implements SysUserServiceSpi {
    private static final Logger log = LogManager.getLogger(SysUserServiceProvider.class);
    @Autowired(required=false)
    private SysTenantMngService tenantService;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    public String getServiceName() {
        return "\u79df\u6237\u7ba1\u7406";
    }

    public void beforeUserAdd(SysUserNewParam userNewParam) {
        if (!this.tenantClientProvider.enabledTenant()) {
            return;
        }
        Long sysTenantId = userNewParam.getTenantId();
        if (sysTenantId == null) {
            return;
        }
        ApiResult<Boolean> result = this.tenantService.exists(sysTenantId);
        if (result == null || Boolean.FALSE.equals(result.getData())) {
            throw new BusinessException("\u79df\u6237\u4e0d\u5b58\u5728");
        }
    }

    public void afterUserAdd(SysUserNewParam userNewParam, Long sysUserId) {
        if (!this.tenantClientProvider.enabledTenant()) {
            return;
        }
        Long sysTenantId = userNewParam.getTenantId();
        if (sysTenantId == null) {
            GeneralUserDetails user = SecurityContextUtil.currentUser();
            this.bindTenantUser(user, sysUserId);
            return;
        }
        this.tenantService.updateUserBindTenant(sysUserId, sysTenantId);
    }

    public void afterUserUpdate(Long sysUserId) {
        if (!this.tenantClientProvider.enabledTenant()) {
            return;
        }
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        this.bindTenantUser(user, sysUserId);
    }

    public void afterUserDelete(Long sysUserId) {
        if (!this.tenantClientProvider.enabledTenant()) {
            return;
        }
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        this.unbindTenantUser(user, sysUserId);
    }

    private void bindTenantUser(GeneralUserDetails currentUser, Long sysUserId) {
        if (sysUserId == null) {
            log.info("\u7528\u6237\u7ed1\u5b9a\u79df\u6237\u5931\u8d25\uff0c\u7528\u6237ID\u4e3a\u7a7a");
            return;
        }
        SysTenantDTO tenant = this.obtainCurrentTenant(currentUser);
        if (tenant == null) {
            log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u6240\u5c5e\u79df\u6237\uff0c\u65e0\u9700\u7ed1\u5b9a");
            return;
        }
        this.tenantService.updateUserBindTenant(sysUserId, tenant.getId());
    }

    private void unbindTenantUser(GeneralUserDetails currentUser, Long sysUserId) {
        if (currentUser == null) {
            return;
        }
        if (currentUser.isSystemAdmin() || currentUser.isOperation()) {
            throw new BusinessException("\u8bf7\u4f7f\u7528\u79df\u6237\u7ba1\u7406\u5458\u5220\u9664\u79df\u6237");
        }
        SysTenantDTO tenant = this.obtainCurrentTenant(currentUser);
        if (tenant == null) {
            throw new BusinessException("\u672a\u77e5\u5f53\u524d\u7528\u6237\u6240\u5c5e\u79df\u6237");
        }
        this.tenantService.updateUserUnbindTenant(sysUserId, tenant.getId());
    }

    private SysTenantDTO obtainCurrentTenant(GeneralUserDetails currentUser) {
        SysTenantDTO tenant = (SysTenantDTO)ObjectUtil.defaultIfNull((Object)TenantClient.getSessionTenant(), (Object)TenantClient.getCurrentTenant());
        if (tenant == null) {
            if (currentUser == null) {
                log.warn("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u79df\u6237\u4e0a\u4e0b\u6587\u4e3a\u7a7a\uff0c\u7ed1\u5b9a\u79df\u6237\u7528\u6237\u5931\u8d25\uff01");
                return null;
            }
            if (currentUser.isSystemAdmin() || currentUser.isOperation()) {
                return null;
            }
            tenant = currentUser.getTenant();
        }
        return tenant;
    }
}

