package com.elitescloud.cloudt.tenant.config.support;

import com.elitescloud.cloudt.common.util.RedisUtils;
import com.elitescloud.cloudt.context.redis.RedisWrapper;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.tenant.rpc.TenantRpcProvider;
import com.elitescloud.cloudt.tenant.service.SysTenantQueryService;
import lombok.extern.log4j.Log4j2;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/9/21
 */
@Log4j2
public class ServerTenantProvider extends DefaultTenantProvider {

    private final SysTenantQueryService tenantService;

    public ServerTenantProvider(TenantRpcProvider tenantRpcProvider, RedisUtils redisUtils, RedisWrapper redisWrapper,
                                SysTenantQueryService tenantService) {
        super(tenantRpcProvider, redisUtils, redisWrapper);
        this.tenantService = tenantService;
    }

    protected List<SysTenantDTO> queryAllFromServer() {
        return tenantService.allTenants().getData();
    }
}
