package com.elitescloud.cloudt.tenant.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/12
 */
@Entity
@Table(name = "sys_tenant_bdata_sync_detail", indexes = {
        @Index(name = "idx_tenant_bdata_sync_d_sync", columnList = "syncId"),
})
@Comment("租户基础数据迁移记录明细")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
public class SysTenantBaseDataSyncDetailDO extends BaseModel {
    private static final long serialVersionUID = 9173835267467394251L;

    @Column(nullable = false)
    @Comment("同步记录ID")
    private Long syncId;

    /**
     * {@link com.elitescloud.cloudt.core.tenant.BasicDataType}
     */
    @Column(nullable = false)
    @Comment("数据类型")
    private String dataType;

    @Column(nullable = false)
    @Comment("是否同步结束")
    private Boolean finished;

    @Column(nullable = false)
    @Comment("是否同步成功")
    private Boolean success;

    @Column()
    @Comment("同步开始时间")
    private LocalDateTime startTime;

    @Column()
    @Comment("同步结束时间")
    private LocalDateTime endTime;

    @Column()
    @Lob
    @Comment("同步失败原因")
    private String failReason;
}
