package com.elitescloud.cloudt.tenant.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/3/27
 */
@Entity
@Table(name = "sys_tenant_db_migrate", indexes = {
        @Index(name = "idx_tenant_db_migrate_tenant_id", columnList = "sysTenantId")
})
@Comment("租户数据库的创建记录")
@Getter
@Setter
@ToString
@Accessors(chain = true)
public class SysTenantDbMigrateDO extends BaseModel {
    private static final long serialVersionUID = 762175807807196772L;

    @Comment("租户ID")
    @Column(nullable = false)
    private Long sysTenantId;

    @Comment("应用编码")
    @Column(nullable = false)
    private String appCode;

    @Comment("租户数据隔离策略")
    @Column(nullable = false)
    private String tenantIsolation;

    @Comment("租户数据隔离数据源")
    @Column()
    private Long databaseSourceId;

    @Comment("schema名称")
    @Column()
    private String schemaName;

    @Comment("是否已成功")
    @Column()
    private Boolean migrateSuccess;

    @Comment("迁移开始时间")
    @Column()
    private LocalDateTime migrateStartTime;

    @Comment("迁移结束时间")
    @Column()
    private LocalDateTime migrateFinishTime;

    @Comment("失败原因")
    @Lob
    @Column()
    private String failReason;

    @Override
    public int hashCode() {
        return getId().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysTenantDbMigrateDO) {
            SysTenantDbMigrateDO the = (SysTenantDbMigrateDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
