package com.elitescloud.cloudt.tenant.model.vo.params;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 数据源表(SysDatabaseSource)实体类
 *
 * @author roman.zhang
 * @since 2022-02-16 16:42:45
 */

@Data
@ApiModel(value = "sys_database_source", description = "数据源表")
public class SysDatabaseSourceQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 288225368554617797L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 数据源名称
     */
    @ApiModelProperty("数据源名称")
    private String dbsName;
    /**
     * 驱动类
     */
    @ApiModelProperty("驱动类")
    private String dbsDriverClass;
    /**
     * 连接地址
     */
    @ApiModelProperty("连接地址")
    private String dbsUrl;
    /**
     * 驱动类
     */
    @ApiModelProperty("驱动类")
    private String dbsUsername;

    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
}
