package com.elitescloud.cloudt.tenant.service.repo;

import com.elitescloud.cloudt.core.common.BaseRepoProc;
import com.elitescloud.cloudt.tenant.model.entity.QSysTenantBaseDataSyncDO;
import com.elitescloud.cloudt.tenant.model.entity.QSysTenantBaseDataSyncDetailDO;
import com.elitescloud.cloudt.tenant.model.entity.SysTenantBaseDataSyncDO;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/12
 */
@Repository
public class SysTenantBaseDataSyncRepoProc extends BaseRepoProc<SysTenantBaseDataSyncDO> {
    private static final QSysTenantBaseDataSyncDO QDO = QSysTenantBaseDataSyncDO.sysTenantBaseDataSyncDO;
    private static final QSysTenantBaseDataSyncDetailDO QDO_DETAIL = QSysTenantBaseDataSyncDetailDO.sysTenantBaseDataSyncDetailDO;

    protected SysTenantBaseDataSyncRepoProc() {
        super(QDO);
    }

    /**
     * 更新开始时间
     *
     * @param id
     */
    public void updateStarted(Long id) {
        jpaQueryFactory.update(QDO)
                .set(QDO.finished, false)
                .set(QDO.success, false)
                .set(QDO.startTime, LocalDateTime.now())
                .where(QDO.id.eq(id))
                .execute();
    }

    /**
     * 更新结束
     *
     * @param id
     * @param success
     * @param failReason
     */
    public void updateEnd(Long id, boolean success, String failReason) {
        jpaQueryFactory.update(QDO)
                .set(QDO.finished, true)
                .set(QDO.success, success)
                .set(QDO.endTime, LocalDateTime.now())
                .set(QDO.failReason, failReason)
                .where(QDO.id.eq(id))
                .execute();
    }

    /**
     * 所有更新为结束
     */
    public void updateFinishedAll() {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.finished, true)
                .where(QDO.finished.eq(false))
                .execute();
    }

    /**
     * 判断是否结束
     *
     * @param id
     * @return
     */
    public Boolean getFinished(Long id) {
        return super.getValue(QDO.finished, id);
    }

    /**
     * 判断是否结束
     *
     * @param tenantId 租户ID
     * @return 最后一条未结束的记录
     */
    public SysTenantBaseDataSyncDO getLastOfUnFinished(long tenantId) {
        return super.jpaQueryFactory.selectFrom(QDO)
                .where(QDO.sysTenantId.eq(tenantId).and(QDO.finished.eq(false)))
                .orderBy(QDO.startTime.desc())
                .limit(1)
                .fetchOne();
    }
}
