/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.param.IdCodeNameCheckParam;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.core.app.PlatformAppProvider;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantAppDO;
import com.elitescloud.cloudt.system.service.repo.SysTenantAppRepo;
import com.elitescloud.cloudt.system.service.repo.SysTenantAppRepoProc;
import com.elitescloud.cloudt.tenant.service.SysTenantAppService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysTenantAppServiceImpl
implements SysTenantAppService {
    private static final Logger log = LogManager.getLogger(SysTenantAppServiceImpl.class);
    @Autowired
    private SysTenantAppRepo tenantAppRepo;
    @Autowired
    private SysTenantAppRepoProc tenantAppRepoProc;
    @Autowired
    private PlatformAppProvider platformAppProvider;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveApps(Long tenantId, Set<String> appCode) {
        if (tenantId == null) {
            return ApiResult.fail((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        Set existsCodes = this.tenantAppRepoProc.getAppCode(tenantId);
        LocalDateTime now = LocalDateTime.now();
        ArrayList<SysTenantAppDO> codesToAdd = new ArrayList<SysTenantAppDO>(appCode.size());
        SysTenantAppDO appDO = null;
        for (String s : appCode) {
            if (existsCodes.contains(s)) continue;
            appDO = new SysTenantAppDO();
            appDO.setAppCode(s);
            appDO.setSysTenantId(tenantId);
            appDO.setAssignTime(now);
            codesToAdd.add(appDO);
        }
        HashSet<String> codesToDel = new HashSet<String>(existsCodes.size());
        for (String s : existsCodes) {
            if (appCode.contains(s)) continue;
            codesToDel.add(s);
        }
        if (!codesToAdd.isEmpty()) {
            this.tenantAppRepo.saveAll(codesToAdd);
        }
        if (!codesToDel.isEmpty()) {
            this.tenantAppRepoProc.deleteByTenantAndAppCode(tenantId, codesToDel);
        }
        return ApiResult.ok((Object)tenantId);
    }

    @Override
    public ApiResult<List<IdCodeNameCheckParam>> getApps(Long tenantId) {
        if (tenantId == null) {
            return ApiResult.fail((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        Set existsCodes = this.tenantAppRepoProc.getAppCode(tenantId);
        if (existsCodes.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List apps = this.platformAppProvider.all();
        if (apps.isEmpty()) {
            return ApiResult.fail((String)"\u83b7\u53d6\u5e73\u53f0\u5e94\u7528\u5931\u8d25");
        }
        List result = apps.stream().map(t -> {
            IdCodeNameCheckParam param = new IdCodeNameCheckParam();
            param.setCode(t.getCode());
            param.setName(t.getName());
            param.setChecked(Boolean.valueOf(existsCodes.contains(t.getCode())));
            return param;
        }).collect(Collectors.toList());
        return ApiResult.ok(result);
    }
}

