/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.manager;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.core.tenant.BasicDataType;
import com.elitescloud.cloudt.system.service.SysTenantBasicDataService;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantDO;
import com.elitescloud.cloudt.tenant.config.TenantProperties;
import com.elitescloud.cloudt.tenant.model.entity.SysTenantBaseDataSyncDetailDO;
import com.elitescloud.cloudt.tenant.model.entity.SysTenantDbMigrateDO;
import com.elitescloud.cloudt.tenant.service.SysTenantDbMigrateService;
import com.elitescloud.cloudt.tenant.service.manager.TenantClientCaller;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantBaseDataSyncDetailRepo;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantBaseDataSyncDetailRepoProc;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantBaseDataSyncRepo;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantBaseDataSyncRepoProc;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantRepoProc;
import java.time.LocalDateTime;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SysTenantManager {
    private static final Logger log = LogManager.getLogger(SysTenantManager.class);
    @Autowired
    private SysTenantRepoProc sysTenantRepoProc;
    @Autowired
    private SysTenantBaseDataSyncRepo baseDataSyncRepo;
    @Autowired
    private SysTenantBaseDataSyncRepoProc baseDataSyncRepoProc;
    @Autowired
    private SysTenantBaseDataSyncDetailRepo baseDataSyncDetailRepo;
    @Autowired
    private SysTenantBaseDataSyncDetailRepoProc baseDataSyncDetailRepoProc;
    @Autowired
    private SysTenantBasicDataService tenantBasicDataService;
    @Autowired
    private SysTenantDbMigrateService tenantDbMigrateService;
    @Autowired
    private TenantProperties tenantProperties;
    @Autowired
    @Qualifier(value="cloudt_taskExecutor")
    private TaskExecutor taskExecutor;
    @Autowired
    private TenantClientCaller tenantClientCaller;

    public boolean syncClientDb(SysTenantDO tenantDO) {
        if (!CharSequenceUtil.equals((CharSequence)tenantDO.getTenantIsolation(), (CharSequence)TenantIsolateStrategy.SCHEMA.name()) && !CharSequenceUtil.equals((CharSequence)tenantDO.getTenantIsolation(), (CharSequence)TenantIsolateStrategy.DATABASE.name())) {
            return false;
        }
        if (Boolean.TRUE.equals(this.tenantProperties.isAsyncCall())) {
            CompletableFuture.supplyAsync(() -> this.executeSyncClientDb(tenantDO), (Executor)this.taskExecutor).whenComplete((res, e) -> {
                if (e != null) {
                    log.error("\u66f4\u65b0\u5ba2\u6237\u7aef\u79df\u6237schema\u5f02\u5e38\uff1a", e);
                    return;
                }
                log.info("\u66f4\u65b0\u5ba2\u6237\u7aef\u79df\u6237\u3010{}, {}\u3011schema\u6210\u529f\uff01", (Object)tenantDO.getSchemaName(), (Object)tenantDO.getId());
            });
            return true;
        }
        return this.executeSyncClientDb(tenantDO);
    }

    public boolean retryDbMigrate(SysTenantDbMigrateDO migrateDO) {
        this.syncTargetClientDb(migrateDO.getId(), migrateDO.getAppCode(), migrateDO.getSchemaName());
        return true;
    }

    public boolean deleteClientDb(SysTenantDO tenantDO) {
        if (!CharSequenceUtil.equals((CharSequence)tenantDO.getTenantIsolation(), (CharSequence)TenantIsolateStrategy.SCHEMA.name()) && !CharSequenceUtil.equals((CharSequence)tenantDO.getTenantIsolation(), (CharSequence)TenantIsolateStrategy.DATABASE.name())) {
            return false;
        }
        CompletableFuture.supplyAsync(() -> this.executeDeleteClientDb(tenantDO), (Executor)this.taskExecutor).whenComplete((res, e) -> {
            if (e != null) {
                log.error("\u5220\u9664\u5ba2\u6237\u7aef\u79df\u6237schema\u5f02\u5e38\uff1a", e);
            }
            log.info("\u5220\u9664\u5ba2\u6237\u7aef\u79df\u6237\u3010{}, {}\u3011\u6210\u529f\uff01", (Object)tenantDO.getSchemaName(), (Object)tenantDO.getId());
        });
        return true;
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @TenantOrgTransaction(useTenantOrg=false)
    public void syncBaseData(long syncId, long tenantId) {
        this.baseDataSyncRepoProc.updateStarted(syncId);
        String failReason = "";
        Throwable exception = null;
        boolean success = true;
        try {
            this.syncBaseData(tenantId, syncId, BasicDataType.UDC);
            this.syncBaseData(tenantId, syncId, BasicDataType.SEQUENCE);
            log.info("\u540c\u6b65\u79df\u6237\u3010" + tenantId + "\u3011\u57fa\u7840\u6570\u636e\u6210\u529f");
        }
        catch (Throwable e) {
            log.error("\u540c\u6b65\u79df\u6237\u3010" + tenantId + "\u3011\u57fa\u7840\u6570\u636e\u5f02\u5e38\uff1a", e);
            failReason = ExceptionUtil.stacktraceToString((Throwable)e, (int)-1);
            exception = e;
            success = false;
        }
        try {
            this.baseDataSyncRepoProc.updateEnd(syncId, success, failReason);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u540c\u6b65\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e);
            if (exception == null) {
                return;
            }
            throw new RuntimeException(exception);
        }
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @TenantOrgTransaction(useTenantOrg=false)
    public void updateSyncResult(long syncId, Throwable throwable) {
        if (throwable == null) {
            this.baseDataSyncRepoProc.updateEnd(syncId, true, null);
            return;
        }
        String failReason = ExceptionUtil.stacktraceToString((Throwable)throwable, (int)-1);
        this.baseDataSyncRepoProc.updateEnd(syncId, false, failReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncBaseData(Long tenantId, Long syncId, BasicDataType dataType) {
        SysTenantBaseDataSyncDetailDO detailDO = new SysTenantBaseDataSyncDetailDO();
        detailDO.setSyncId(syncId);
        detailDO.setDataType(dataType.getValue());
        detailDO.setFinished(false);
        detailDO.setSuccess(false);
        detailDO.setStartTime(LocalDateTime.now());
        this.baseDataSyncDetailRepo.save((Object)detailDO);
        boolean success = true;
        String failReason = "";
        try {
            ApiResult syncResult = null;
            syncResult = dataType == BasicDataType.UDC ? this.tenantBasicDataService.syncUdc(tenantId) : (dataType == BasicDataType.SEQUENCE ? this.tenantBasicDataService.syncSequence(tenantId) : ApiResult.fail((String)"\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b"));
            Assert.isTrue((boolean)syncResult.isSuccess(), (String)syncResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u79df\u6237\u3010" + tenantId + "\u3011\u6570\u636e\u3010" + dataType + "\u3011\u5f02\u5e38\uff1a", (Throwable)e);
            success = false;
            failReason = ExceptionUtil.stacktraceToString((Throwable)e, (int)-1);
        }
        finally {
            detailDO.setSuccess(success);
            detailDO.setFinished(true);
            detailDO.setEndTime(LocalDateTime.now());
            detailDO.setFailReason(failReason);
            this.baseDataSyncDetailRepo.save((Object)detailDO);
        }
    }

    private boolean executeDeleteClientDb(SysTenantDO tenantDO) {
        Set<String> apps = this.obtainApps();
        if (CollectionUtils.isEmpty(apps)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u79df\u6237\u5ba2\u6237\u7aef");
        }
        for (String app : apps) {
            Long migrateId = (Long)this.tenantDbMigrateService.getMigrateId(tenantDO.getTenantId(), app).getData();
            if (migrateId == null) continue;
            this.deleteTargetClientDb(migrateId, app, tenantDO.getSchemaName());
        }
        this.sysTenantRepoProc.updateDbInitialized(tenantDO.getId(), false);
        return true;
    }

    private Set<String> obtainApps() {
        Set<String> apps = this.tenantProperties.getClientNames();
        if (this.tenantProperties.isDiscoveryClient() && CollectionUtils.isEmpty(apps)) {
            apps = this.tenantClientCaller.allAppCodes();
        }
        return apps;
    }

    private boolean executeSyncClientDb(SysTenantDO tenantDO) {
        TenantIsolateStrategy isolateStrategy = TenantIsolateStrategy.parse((String)tenantDO.getTenantIsolation());
        Set<String> apps = this.obtainApps();
        if (CollectionUtils.isEmpty(apps)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u79df\u6237\u5ba2\u6237\u7aef");
        }
        for (String app : apps) {
            Long migrateId = (Long)this.tenantDbMigrateService.addInit(tenantDO, isolateStrategy, app).getData();
            this.syncTargetClientDb(migrateId, app, tenantDO.getSchemaName());
        }
        return true;
    }

    private void deleteTargetClientDb(Long migrateId, String appCode, String schemaName) {
        boolean success = false;
        try {
            this.tenantClientCaller.callDatabaseRpcProvider(appCode, this.tenantProperties.getCreateTimeOut(), rpcProvider -> {
                ApiResult deleteResult = rpcProvider.schemaDrop(schemaName);
                if (deleteResult != null && deleteResult.isSuccess()) {
                    log.info("\u5220\u9664\u79df\u6237\u5ba2\u6237\u7aefschema\u6210\u529f\uff1a{}\uff0c{}", (Object)appCode, (Object)schemaName);
                    return true;
                }
                return false;
            });
            success = true;
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u79df\u6237\u5ba2\u6237\u7aefschema\u5f02\u5e38\uff1a", (Throwable)e);
        }
        if (success) {
            this.tenantDbMigrateService.updateResult(migrateId, false, "\u5df2\u5220\u9664");
        }
    }

    private void syncTargetClientDb(Long migrateId, String appCode, String schemaName) {
        String lastError = null;
        boolean success = false;
        try {
            this.tenantClientCaller.callDatabaseRpcProvider(appCode, this.tenantProperties.getCreateTimeOut(), rpcProvider -> {
                ApiResult createResult = rpcProvider.schemaCreate(schemaName);
                return createResult != null && createResult.isSuccess();
            });
            success = true;
        }
        catch (Exception e) {
            lastError = e.getMessage();
        }
        if (success) {
            this.tenantDbMigrateService.updateResult(migrateId, true, null);
        } else {
            this.tenantDbMigrateService.updateResult(migrateId, false, lastError);
        }
    }
}

