package com.elitescloud.cloudt.tenant.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * 租户基础数据同步记录.
 *
 * @author Kaiser（wang shao）
 * 2022/10/12
 */
@Entity
@Table(name = "sys_tenant_bdata_sync", indexes = {
        @Index(name = "idx_tenant_bdata_sync_tenant", columnList = "sysTenantId"),
})
@Comment("租户基础数据同步记录")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
public class SysTenantBaseDataSyncDO extends BaseModel {
    private static final long serialVersionUID = 9173835267467394251L;

    @Column(nullable = false)
    @Comment("租户ID")
    private Long sysTenantId;

    @Column(nullable = false)
    @Comment("是否同步结束")
    private Boolean finished;

    @Column(nullable = false)
    @Comment("是否同步成功")
    private Boolean success;

    @Column()
    @Comment("同步开始时间")
    private LocalDateTime startTime;

    @Column()
    @Comment("同步结束时间")
    private LocalDateTime endTime;

    @Column()
    @Lob
    @Comment("同步失败原因")
    private String failReason;
}
