package com.elitescloud.cloudt.tenant.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.tenant.service.SysTenantQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 租户RPC服务.
 *
 * @author Kaiser（wang shao）
 * 2022/3/24
 */
@ResponseBody
@RequestMapping(value = TenantRpcProvider.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class TenantRpcProviderImpl implements TenantRpcProvider {

    @Autowired
    private SysTenantQueryService tenantService;

    @Override
    public ApiResult<List<SysTenantDTO>> allTenants() {
        return tenantService.allTenants();
    }

    @Override
    public ApiResult<SysTenantDTO> getById(Long id) {
        return tenantService.getDtoById(id);
    }
}
