package com.elitescloud.cloudt.tenant.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.param.IdCodeNameCheckParam;

import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
public interface SysTenantAppService {

    /**
     * 保存租户的应用
     *
     * @param tenantId 租户ID
     * @param appCode  应用编码
     * @return
     */
    ApiResult<Long> saveApps(Long tenantId, Set<String> appCode);

    /**
     * 获取租户绑定的应用
     *
     * @param tenantId 租户ID
     * @return
     */
    ApiResult<List<IdCodeNameCheckParam>> getApps(Long tenantId);
}
