package com.elitescloud.cloudt.tenant.service.impl;

import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.tenant.convert.SysDatabaseSourceConvert;
import com.elitescloud.cloudt.tenant.model.entity.SysDatabaseSourceDO;
import com.elitescloud.cloudt.tenant.service.repo.SysDatabaseSourceRepo;
import com.elitescloud.cloudt.tenant.model.vo.params.SysDatabaseSourceQueryParam;
import com.elitescloud.cloudt.tenant.model.vo.params.SysDatabaseSourceUpdateParam;
import com.elitescloud.cloudt.tenant.service.SysDatabaseSourceService;
import com.elitescloud.cloudt.tenant.service.repo.SysDatabaseSourceRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.develop.vo.SysDatabaseSourceVO;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-02-16 16:42:42
 */
//@Service
@RequiredArgsConstructor
@TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg = false)
public class SysDatabaseSourceServiceImpl implements SysDatabaseSourceService {

    private static final SysDatabaseSourceConvert CONVERT = SysDatabaseSourceConvert.INSTANCE;

    private final SysDatabaseSourceRepo sysDatabaseSourceRepo;

    private final SysDatabaseSourceRepoProc sysDatabaseSourceRepoProc;


    @Override
    @SysCodeProc
    public PagingVO<SysDatabaseSourceVO> search(SysDatabaseSourceQueryParam param) {
        val ret = sysDatabaseSourceRepo.findAll(sysDatabaseSourceRepoProc.where(param), param.getPageRequest());
        val vos = ret.getContent().stream().map(SysDatabaseSourceConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.<SysDatabaseSourceVO>builder()
                .total(ret.getTotalElements())
                .records(vos)
                .build();
    }

    @Override
    @SysCodeProc
    public Optional<SysDatabaseSourceVO> findIdOne(Long id) {
        return sysDatabaseSourceRepo.findById(id).map(SysDatabaseSourceConvert.INSTANCE::doToVO);
    }

    @Override
    @Transactional
    public Long createOne(SysDatabaseSourceDO sysDatabaseSourceDO) {

        return sysDatabaseSourceRepo.save(sysDatabaseSourceDO).getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<SysDatabaseSourceDO> list) {
        return sysDatabaseSourceRepo.saveAll(list).stream().map(SysDatabaseSourceDO::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void update(SysDatabaseSourceUpdateParam updateParam) {
        Optional<SysDatabaseSourceDO> optional = sysDatabaseSourceRepo.findById(updateParam.getId());
        if (optional.isPresent()) {
            var sourceDo = optional.get();
            CONVERT.convertUpdateParm(updateParam, sourceDo);
            sysDatabaseSourceRepo.save(sourceDo);
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在");
        }
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        sysDatabaseSourceRepoProc.updateDeleteFlag(id);
    }

    @Override
    @Transactional
    public void deleteById(Long id) {
        this.sysDatabaseSourceRepo.deleteById(id);
    }
}


