package com.elitescloud.cloudt.tenant.service.repo;

import com.elitescloud.cloudt.tenant.model.entity.SysDatabaseSourceDO;
import com.elitescloud.cloudt.tenant.model.entity.QSysDatabaseSourceDO;
import com.elitescloud.cloudt.tenant.model.vo.params.SysDatabaseSourceQueryParam;
import com.elitescloud.cloudt.core.common.BaseRepoProc;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-02-16 16:42:44
 */
@Component
public class SysDatabaseSourceRepoProc extends BaseRepoProc<SysDatabaseSourceDO> {

    private static final QSysDatabaseSourceDO QDO = QSysDatabaseSourceDO.sysDatabaseSourceDO;

    public SysDatabaseSourceRepoProc() {
        super(QDO);
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(SysDatabaseSourceQueryParam param) {
        val jpaQDo = QSysDatabaseSourceDO.sysDatabaseSourceDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getDbsName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.dbsName.eq(param.getDbsName()));
        }
        if (!StringUtils.isEmpty(param.getDbsDriverClass())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.dbsDriverClass.eq(param.getDbsDriverClass()));
        }
        if (!StringUtils.isEmpty(param.getDbsUrl())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.dbsUrl.eq(param.getDbsUrl()));
        }
        if (!StringUtils.isEmpty(param.getDbsUsername())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.dbsUsername.eq(param.getDbsUsername()));
        }

        if (!StringUtils.isEmpty(param.getTenantId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.tenantId.eq(param.getTenantId()));
        }
        if (!StringUtils.isEmpty(param.getRemark())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.remark.eq(param.getRemark()));
        }


        return predicate;
    }
}

