package com.elitescloud.cloudt.tenant.service.repo;

import com.elitescloud.cloudt.core.common.BaseRepoProc;
import com.elitescloud.cloudt.tenant.model.entity.QSysTenantBaseDataSyncDetailDO;
import com.elitescloud.cloudt.tenant.model.entity.SysTenantBaseDataSyncDetailDO;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/12
 */
@Repository
public class SysTenantBaseDataSyncDetailRepoProc extends BaseRepoProc<SysTenantBaseDataSyncDetailDO> {
    private static final QSysTenantBaseDataSyncDetailDO QDO = QSysTenantBaseDataSyncDetailDO.sysTenantBaseDataSyncDetailDO;

    protected SysTenantBaseDataSyncDetailRepoProc() {
        super(QDO);
    }

    /**
     * 更新结束
     *
     * @param id
     * @param success
     * @param failReason
     */
    public void updateEnd(Long id, boolean success, String failReason) {
        jpaQueryFactory.update(QDO)
                .set(QDO.finished, true)
                .set(QDO.success, success)
                .set(QDO.endTime, LocalDateTime.now())
                .set(QDO.failReason, failReason)
                .where(QDO.id.eq(id))
                .execute();
    }
}
