/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.provider;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;
import com.elitescloud.cloudt.system.constant.TenantType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.spi.SysUserLoginSpi;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.tenant.service.SysTenantQueryService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class SysUserLoginTenantProvider
implements SysUserLoginSpi {
    private static final Logger log = LogManager.getLogger(SysUserLoginTenantProvider.class);
    @Autowired(required=false)
    private SysTenantQueryService tenantService;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    public String getServiceName() {
        return "\u79df\u6237\u4fe1\u606f\u670d\u52a1";
    }

    public void expendLoginUserInfo(SysUserDTO user) {
        user.setSysTenantDTOList(Collections.emptyList());
        if (!this.tenantClientProvider.enabledTenant()) {
            return;
        }
        List tenants = (List)this.tenantService.queryTenantDtoOfUser(user.getId()).getData();
        user.setSysTenantDTOList((List)ObjectUtil.defaultIfNull((Object)tenants, Collections.emptyList()));
        this.chooseCurrentTenant(user, tenants);
        log.info("\u79df\u6237\uff1a{}", (Object)tenants);
        log.info("\u5f53\u524d\u79df\u6237\uff1a{}", (Object)user.getSysTenantVO());
    }

    private void chooseCurrentTenant(SysUserDTO user, List<SysTenantDTO> tenants) {
        if (CollectionUtils.isEmpty(tenants)) {
            return;
        }
        SysTenantDTO requestTenant = this.tenantClientProvider.getCurrentTenant();
        if (requestTenant != null) {
            Optional<SysTenantDTO> matchTenant = tenants.stream().filter(t -> t.getId().longValue() == requestTenant.getId().longValue()).findAny();
            if (matchTenant.isPresent()) {
                user.setSysTenantVO(matchTenant.get());
                return;
            }
            user.setSysTenantVO(tenants.get(0));
            return;
        }
        user.setSysTenantVO(tenants.get(0));
        if (this.tenantClientProvider.isDefaultDomainRequest()) {
            Optional<SysTenantDTO> operationTenant = tenants.stream().filter(t -> t.getType() == TenantType.OPERATION).findAny();
            operationTenant.ifPresent(arg_0 -> ((SysUserDTO)user).setSysTenantVO(arg_0));
        }
    }
}

