/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.param.IdCodeNameCheckParam;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.core.app.PlatformAppProvider;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.cloudt.system.constant.TenantType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantDO;
import com.elitescloud.cloudt.system.service.repo.SysTenantAppRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysTenantUserRepoProc;
import com.elitescloud.cloudt.tenant.convert.SysTenantConvert;
import com.elitescloud.cloudt.tenant.service.SysTenantQueryService;
import com.elitescloud.cloudt.tenant.service.impl.SysTenantMngServiceImpl;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysTenantQueryServiceImpl
extends BaseServiceImpl
implements SysTenantQueryService {
    private static final Logger log = LogManager.getLogger(SysTenantQueryServiceImpl.class);
    private static final SysTenantConvert CONVERT = SysTenantConvert.INSTANCE;
    @Autowired
    private SysTenantRepoProc sysTenantRepoProc;
    @Autowired
    private SysTenantAppRepoProc tenantAppRepoProc;
    @Autowired
    private SysTenantUserRepoProc sysTenantUserRepoProc;
    @Autowired
    private PlatformAppProvider platformAppProvider;

    @Override
    public ApiResult<List<SysTenantDTO>> allTenants() {
        List tenantDos = this.sysTenantRepoProc.allForUnDeleted();
        if (tenantDos.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Map appMap = this.tenantAppRepoProc.getAppCodeAll();
        List tenants = tenantDos.stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).map(t -> {
            SysTenantDTO dto = this.do2Dto((SysTenantDO)t);
            dto.setAppCodes((Set)appMap.get(t.getId()));
            return dto;
        }).collect(Collectors.toList());
        return ApiResult.ok(tenants);
    }

    @Override
    public ApiResult<SysTenantDTO> getDtoById(Long id) {
        SysTenantDO tenantDO = (SysTenantDO)this.sysTenantRepoProc.get(id);
        if (tenantDO == null) {
            return ApiResult.fail((String)"\u79df\u6237\u4e0d\u5b58\u5728");
        }
        if (!Boolean.TRUE.equals(tenantDO.getEnabled())) {
            return ApiResult.fail((String)"\u79df\u6237\u5df2\u7981\u7528");
        }
        SysTenantDTO dto = this.do2Dto(tenantDO);
        dto.setAppCodes(this.tenantAppRepoProc.getAppCode(id));
        return ApiResult.ok((Object)dto);
    }

    @Override
    public ApiResult<List<SysTenantDTO>> queryTenantDtoOfUser(Long sysUserId) {
        List tenantDoList = this.sysTenantUserRepoProc.queryUserTenantDetail(sysUserId);
        if (tenantDoList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Set tenantIds = tenantDoList.stream().map(BaseModel::getId).collect(Collectors.toSet());
        Map tenantApps = this.tenantAppRepoProc.getAppCodes(tenantIds);
        List tenants = tenantDoList.stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).map(t -> {
            SysTenantDTO dto = this.do2Dto((SysTenantDO)t);
            dto.setAppCodes(tenantApps.getOrDefault(t.getId(), Collections.emptySet()));
            return dto;
        }).collect(Collectors.toList());
        return ApiResult.ok(tenants);
    }

    @Override
    public ApiResult<List<IdCodeNameCheckParam>> getApps(Long tenantId) {
        if (tenantId == null) {
            return ApiResult.fail((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        List apps = this.platformAppProvider.all();
        if (apps.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u5e94\u7528\u5217\u8868");
        }
        Set existsCodes = this.tenantAppRepoProc.getAppCode(tenantId);
        List result = apps.stream().map(t -> {
            IdCodeNameCheckParam param = new IdCodeNameCheckParam();
            param.setCode(t.getCode());
            param.setName(t.getName());
            param.setChecked(Boolean.valueOf(existsCodes.contains(t.getCode())));
            return param;
        }).collect(Collectors.toList());
        return ApiResult.ok(result);
    }

    private SysTenantDTO do2Dto(SysTenantDO tenantDO) {
        SysTenantDTO dto = CONVERT.do2Dto(tenantDO);
        dto.setType(TenantType.parse((String)tenantDO.getTenantType()));
        dto.setIsolationStrategy(SysTenantMngServiceImpl.convertTenantIsolate(tenantDO.getTenantIsolation()));
        return dto;
    }
}

