/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.manager.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.openfeign.common.DynamicClientHelper;
import com.elitescloud.boot.tenant.client.common.TenantDatabaseRpcProvider;
import com.elitescloud.cloudt.tenant.service.manager.TenantClientCaller;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;

public class OpenFeignTenantClientCaller
implements TenantClientCaller {
    private static final Logger log = LogManager.getLogger(OpenFeignTenantClientCaller.class);
    private final DynamicClientHelper dynamicClientHelper;

    public OpenFeignTenantClientCaller(ApplicationContext applicationContext) {
        this.dynamicClientHelper = new DynamicClientHelper(applicationContext);
    }

    @Override
    public Set<String> allAppCodes() {
        return Collections.emptySet();
    }

    @Override
    public boolean callDatabaseRpcProvider(@NonNull String appCode, Integer timeout, @NonNull Predicate<TenantDatabaseRpcProvider> rpcProviderCall) {
        TenantDatabaseRpcProvider tenantDatabaseRpcProvider = (TenantDatabaseRpcProvider)this.dynamicClientHelper.getClient(appCode, TenantDatabaseRpcProvider.class, "/rpc/tenant/client/db");
        boolean result = false;
        try {
            result = rpcProviderCall.test(tenantDatabaseRpcProvider);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u79df\u6237\u5ba2\u6237\u7aef\u6267\u884c\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u79df\u6237\u5ba2\u6237\u7aef\u63a5\u53e3\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage());
        }
        return result;
    }
}

