package com.elitescloud.cloudt.tenant.service;


import com.elitescloud.cloudt.tenant.model.entity.SysDatabaseSourceDO;
import com.elitescloud.cloudt.tenant.model.vo.params.SysDatabaseSourceQueryParam;
import com.elitescloud.cloudt.tenant.model.vo.params.SysDatabaseSourceUpdateParam;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.develop.vo.SysDatabaseSourceVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-02-16 16:42:42
 */
public interface SysDatabaseSourceService {
    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<SysDatabaseSourceVO> search(SysDatabaseSourceQueryParam param);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    Optional<SysDatabaseSourceVO> findIdOne(Long id);

    /**
     * 新增数据
     *
     * @param sysDatabaseSource 数据信息
     * @return
     */
    Long createOne(SysDatabaseSourceDO sysDatabaseSource);

    /**
     * 批量新增数据
     *
     * @param list 数据信息
     */
    List<Long> createBatch(List<SysDatabaseSourceDO> list);

    /**
     * 修改数据
     *
     * @param updateParam
     * @return 修改数据详情
     */
    void update(SysDatabaseSourceUpdateParam updateParam);

    /**
     * 逻辑删除数据
     * @param id
     */
    void updateDeleteFlag(Long id);

    /**
     * 删除数据
     *
     * @param id
     * @return 删除情况
     */
    void deleteById(Long id);
}


