package com.elitescloud.cloudt.tenant.service.manager.impl;

import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.openfeign.common.DynamicClientHelper;
import com.elitescloud.boot.tenant.client.common.TenantDatabaseRpcProvider;
import com.elitescloud.cloudt.tenant.service.manager.TenantClientCaller;
import lombok.extern.log4j.Log4j2;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/8/1
 */
@Log4j2
public class OpenFeignTenantClientCaller implements TenantClientCaller {

    private final DynamicClientHelper dynamicClientHelper;

    public OpenFeignTenantClientCaller(ApplicationContext applicationContext) {
        this.dynamicClientHelper = new DynamicClientHelper(applicationContext);
    }

    @Override
    public Set<String> allAppCodes() {
        return Collections.emptySet();
    }

    @Override
    public boolean callDatabaseRpcProvider(@NonNull String appCode, Integer timeout, @NonNull Predicate<TenantDatabaseRpcProvider> rpcProviderCall) {
        TenantDatabaseRpcProvider tenantDatabaseRpcProvider = dynamicClientHelper.getClient(appCode, TenantDatabaseRpcProvider.class, TenantConstant.URI_PATH_DB_PREFIX);

        boolean result = false;
        try {
            result = rpcProviderCall.test(tenantDatabaseRpcProvider);
        } catch (Exception e) {
            log.error("调用租户客户端执行失败：", e);
            throw new BusinessException("调用租户客户端接口执行失败：" + e.getMessage());
        }
        return result;
    }
}
