package com.elitescloud.cloudt.tenant.service.repo;

import cn.hutool.core.util.RandomUtil;
import com.blazebit.persistence.querydsl.BlazeJPAQueryFactory;
import com.elitescloud.boot.common.param.ComSearchParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.provider.CloudtIdCreator;
import com.elitescloud.cloudt.tenant.model.entity.QTestDemoClassesDO;
import com.elitescloud.cloudt.tenant.model.entity.QTestDemoDO;
import com.elitescloud.cloudt.tenant.model.entity.TestDemoDO;
import com.querydsl.core.types.Projections;
import lombok.Data;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/3/25
 */
@Repository
@Log4j2
public class TestDemoRepoProc extends BaseRepoProc<TestDemoDO> {
    @Autowired
    private CloudtIdCreator idCreator;

    private static final QTestDemoDO QDO = QTestDemoDO.testDemoDO;
    private static final QTestDemoClassesDO QDO_CLASSES = QTestDemoClassesDO.testDemoClassesDO;

    public TestDemoRepoProc() {
        super(QDO);
    }

    public Long upsert(String username, Long id) {
        if (id == null) {
            id = idCreator.create();
            log.info("ID：{}", id);
//            new BlazeJPAQueryFactory(entityManager, criteriaBuilderFactory)
//                    .insert(QDO)
            jpaQueryFactory.insert(QDO)
//                    .set(QDO.id, id)
//                    .set(QDO.username, username)
//                    .set(QDO.age, RandomUtil.randomInt(100))
//                    .set(QDO.createTime, LocalDateTime.now())
                    .columns(QDO.id, QDO.username)
                    .values(id, username)
                    .execute();
        } else {
            jpaQueryFactory.update(QDO)
                    .set(QDO.username, username)
                    .where(QDO.id.eq(id))
                    .execute();
        }
        return id;
    }

    public boolean existsUsername(String username) {
        return exists(QDO.username, username);
    }

    public Object queryGroupBy(ComSearchParam searchParam) {
        // 单表简单查询
        var jpaQuery = jpaQueryFactory.selectFrom(QDO)
                .where(QDO.username.isNotNull());

        // 单表group by查询
//        var jpaQuery = jpaQueryFactory.select(QDO.username)
//                .from(QDO)
//                .groupBy(QDO.username)
//                .where(QDO.username.isNotNull());

//        // 不规范写法的支持
//        var jpaQuery = jpaQueryFactory.select(Projections.bean(TestResult.class, QDO.username, QDO.age))
//                .from(QDO)
//                .groupBy(QDO.username)
//                .where(QDO.username.isNotNull());

        // 简单join
//        var jpaQuery = jpaQueryFactory.select(Projections.bean(TestResult.class, QDO.username, QDO_CLASSES.classes))
//                .from(QDO)
//                .leftJoin(QDO_CLASSES).on(QDO_CLASSES.username.eq(QDO.username))
//                .where(QDO.username.isNotNull());
//        var jpaQuery = jpaQueryFactory.select(Projections.bean(TestResult.class, QDO.username, QDO_CLASSES.classes))
//                .from(QDO)
//                .leftJoin(QDO_CLASSES).on(QDO_CLASSES.username.eq(QDO.username))
//                .where(QDO.username.isNotNull().and(QDO_CLASSES.classes.isNotNull()));

        // join + group by
//        var jpaQuery = jpaQueryFactory.select(Projections.bean(TestResult.class, QDO.username))
//                .from(QDO)
//                .leftJoin(QDO_CLASSES).on(QDO_CLASSES.username.eq(QDO.username))
//                .where(QDO.username.isNotNull())
//                .groupBy(QDO.username);
//        var jpaQuery = jpaQueryFactory.select(Projections.bean(TestResult.class, QDO.username, QDO.age))
//                .from(QDO)
//                .leftJoin(QDO_CLASSES).on(QDO_CLASSES.username.eq(QDO.username))
//                .where(QDO.username.isNotNull().and(QDO_CLASSES.classes.isNotNull()))
//                .groupBy(QDO.username);

        return this.queryByPage(jpaQuery, searchParam.getPageRequest());
    }

    @Data
    public static class TestResult implements Serializable {
        private static final long serialVersionUID = -2598546760778982414L;

        private String username;

        private Integer age;

        private String classes;

        private Long count;
    }
}
