package com.elitescloud.cloudt.tenant.controller;

import com.elitescloud.cloudt.tenant.model.entity.SysDatabaseSourceDO;
import com.elitescloud.cloudt.tenant.model.vo.params.SysDatabaseSourceCreateParam;
import com.elitescloud.cloudt.tenant.model.vo.params.SysDatabaseSourceQueryParam;
import com.elitescloud.cloudt.tenant.model.vo.params.SysDatabaseSourceUpdateParam;
import com.elitescloud.cloudt.tenant.service.SysDatabaseSourceService;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.develop.vo.SysDatabaseSourceVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-02-16 16:42:42
 * @ignore
 */
//@RestController
//@RequestMapping("/sys/sysDatabaseSource")
//@Api(value = "数据源表", tags = {"租户数据源"})
@RequiredArgsConstructor
public class SysDatabaseSourceController {

    private final SysDatabaseSourceService sysDatabaseSourceService;

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过主键查询单条数据")
    ApiResult<SysDatabaseSourceVO> findIdOne(@PathVariable Long id) {
        return sysDatabaseSourceService.findIdOne(id).map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }


    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<SysDatabaseSourceVO>> search(@RequestBody SysDatabaseSourceQueryParam param) {
        val ret = sysDatabaseSourceService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 新增数据
     *
     * @param param 新增数据
     * @return 新增数据情况
     */
    @PostMapping("/createOne")
    @ApiOperation("新增数据")
    public ApiResult<Object> createOne(@RequestBody SysDatabaseSourceCreateParam param) {
        SysDatabaseSourceDO DO = new SysDatabaseSourceDO();
        BeanUtils.copyProperties(param, DO);
        return ApiResult.ok(sysDatabaseSourceService.createOne(DO));
    }

    /**
     * 批量新增数据
     *
     * @param list 对象集合
     */
    @PostMapping("/createBatch")
    @ApiOperation("批量新增数据")
    public ApiResult<Object> createBatch(@RequestBody List<SysDatabaseSourceDO> list) {
        val dos = list.stream().map(i -> {
            SysDatabaseSourceDO DO = new SysDatabaseSourceDO();
            BeanUtils.copyProperties(i, DO);
            return DO;
        }).collect(Collectors.toList());
        return ApiResult.ok(sysDatabaseSourceService.createBatch(dos));
    }

    /**
     * 修改数据
     *
     * @param param 修改对象
     * @return 修改数据详情
     */
    @PutMapping("/update")
    @ApiOperation("修改数据")
    public ApiResult<Object> update(@RequestBody SysDatabaseSourceUpdateParam param) {
        sysDatabaseSourceService.update(param);
        return ApiResult.ok();
    }

    /**
     * 根据主键删除数据
     *
     * @param id 主键
     * @return 删除情况
     */
    @DeleteMapping("/deleteOne/{id}")
    @ApiOperation("根据主键删除数据")
    public ApiResult<Object> deleteOne(@PathVariable Long id) {
        sysDatabaseSourceService.deleteById(id);
        return ApiResult.ok();
    }

    /**
     * 逻辑删除
     *
     * @param id 更新数据
     */
    @PutMapping("/updateDeleteFlag/{id}")
    @ApiOperation("逻辑删除")
    public ApiResult<Object> updateDeleteFlag(@PathVariable Long id) {
        sysDatabaseSourceService.updateDeleteFlag(id);
        return ApiResult.ok();
    }
}


