package com.elitescloud.cloudt.tenant.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.tenant.model.entity.QSysTenantDbMigrateDO;
import com.elitescloud.cloudt.tenant.model.entity.SysTenantDbMigrateDO;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/3/27
 */
@Repository
public class SysTenantDbMigrateRepoProc extends BaseRepoProc<SysTenantDbMigrateDO> {

    private static final QSysTenantDbMigrateDO QDO = QSysTenantDbMigrateDO.sysTenantDbMigrateDO;

    public SysTenantDbMigrateRepoProc() {
        super(QDO);
    }

    /**
     * 更新迁移结果
     *
     * @param id         记录ID
     * @param success    是否成功
     * @param failReason 失败原因
     * @return 更新结果
     */
    public boolean updateResult(Long id, boolean success, String failReason) {
        return jpaQueryFactory.update(QDO)
                .set(QDO.migrateSuccess, success)
                .set(QDO.migrateFinishTime, LocalDateTime.now())
                .set(QDO.failReason, failReason)
                .where(QDO.id.eq(id))
                .execute() > 0;
    }

    /**
     * 获取更新迁移失败的数量
     *
     * @param sysTenantId 租户ID
     * @return
     */
    public long countFailNum(Long sysTenantId) {
        return super.count(QDO.sysTenantId, sysTenantId);
    }

    /**
     * 查询租户的相关升级记录
     *
     * @param tenantId 租户ID
     * @return
     */
    public List<SysTenantDbMigrateDO> queryByTenantId(Long tenantId) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.sysTenantId.eq(tenantId))
                .orderBy(QDO.migrateStartTime.desc())
                .fetch();
    }

    /**
     * 根据租户和应用编码
     *
     * @param tenantId
     * @param appCode
     * @return
     */
    public SysTenantDbMigrateDO getByTenantAndAppCode(Long tenantId, String appCode) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.sysTenantId.eq(tenantId).and(QDO.appCode.eq(appCode)))
                .orderBy(QDO.migrateStartTime.desc())
                .limit(1)
                .fetchOne();
    }
}
