package com.elitescloud.cloudt.tenant.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.service.model.vo.SysUserTenantVO;
import com.elitescloud.cloudt.tenant.model.vo.SysTenantVO;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantCreateParam;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantQueryParam;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantUpdateParam;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-02-16 15:16:00
 */
public interface SysTenantMngService {

    /**
     * 新增租户
     *
     * @param sysTenant 租户信息
     * @return 租户ID
     */
    ApiResult<Long> add(SysTenantCreateParam sysTenant);

    /**
     * 修改租户
     *
     * @param updateParam 租户信息
     * @return 租户ID
     */
    ApiResult<Long> update(SysTenantUpdateParam updateParam);

    /**
     * 启用租户
     *
     * @param id      租户ID
     * @param enabled 是否启用
     * @return 租户ID
     */
    ApiResult<Long> updateEnabled(Long id, Boolean enabled);

    /**
     * 删除数据
     *
     * @param id
     * @return 删除情况
     */
    ApiResult<Long> deleteById(Long id);

    /**
     * 逻辑删除
     *
     * @param id
     */
    ApiResult<Long> updateDeleteFlag(Long id);

    /**
     * 给用户绑定租户
     *
     * @param userId   用户ID
     * @param tenantId 租户ID
     * @return 用户ID
     */
    ApiResult<Long> updateUserBindTenant(Long userId, Long tenantId);

    /**
     * 取消绑定用户的租户
     *
     * @param userId   用户ID
     * @param tenantId 租户ID
     * @return 用户ID
     */
    ApiResult<Long> updateUserUnbindTenant(Long userId, Long tenantId);

    /**
     * 保存租户的应用
     *
     * @param tenantId 租户ID
     * @param appCode  应用编码
     * @return
     */
    ApiResult<Long> saveApps(Long tenantId, Set<String> appCode);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 租户详细数据
     */
    ApiResult<SysTenantVO> getDetail(Long id);

    /**
     * 判断租户是否存在
     *
     * @param id
     * @return
     */
    ApiResult<Boolean> exists(Long id);

    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 分页结果集
     */
    ApiResult<PagingVO<SysTenantVO>> search(SysTenantQueryParam param);

    /**
     * 查询用户绑定的租户
     *
     * @param sysUserId 用户ID
     * @return
     */
    ApiResult<List<SysUserTenantVO>> queryTenantOfUser(Long sysUserId);
}


