/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.tenant.convert.TestDemoConvert;
import com.elitescloud.cloudt.tenant.model.entity.TestDemoDO;
import com.elitescloud.cloudt.tenant.model.vo.TestDemoVO;
import com.elitescloud.cloudt.tenant.model.vo.params.TestDemoSaveVO;
import com.elitescloud.cloudt.tenant.service.TestDemoService;
import com.elitescloud.cloudt.tenant.service.repo.TestDemoRepo;
import com.elitescloud.cloudt.tenant.service.repo.TestDemoRepoProc;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TestDemoServiceImpl
implements TestDemoService {
    private static final TestDemoConvert CONVERT = TestDemoConvert.INSTANCE;
    @Autowired
    private TestDemoRepo testDemoRepo;
    @Autowired
    private TestDemoRepoProc testDemoRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(TestDemoSaveVO saveVO) {
        if (CharSequenceUtil.isBlank((CharSequence)saveVO.getUsername())) {
            return ApiResult.fail((String)"\u7528\u6237\u540d\u4e3a\u7a7a");
        }
        boolean exits = this.testDemoRepoProc.existsUsername(saveVO.getUsername(), saveVO.getId());
        if (exits) {
            return ApiResult.fail((String)"\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        TestDemoDO demoDO = CONVERT.saveVo2Do(saveVO);
        demoDO.setJoinTime(LocalDateTime.now());
        demoDO.setAge(2);
        this.testDemoRepoProc.save((Serializable)((Object)demoDO));
        return ApiResult.ok((Object)demoDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> upsert(String username, Long id) {
        id = this.testDemoRepoProc.upsert(username, id);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<List<TestDemoVO>> queryAll() {
        List dos = this.testDemoRepo.findAll();
        List<TestDemoVO> result = CONVERT.do2Vo(dos);
        return ApiResult.ok(result);
    }

    @Override
    @Async
    public void test() {
        System.out.println(TenantClient.getCurrentTenant());
    }
}

