package com.elitescloud.cloudt.tenant.model.vo.params;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 租户数据源保存.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/27
 */
@Data
@ApiModel(description = "租户数据源保存")
public class SysTenantDatasourceSaveVO implements Serializable {
    private static final long serialVersionUID = 7126050449636600137L;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID", position = 0, required = true)
    @NotNull(message = "请选择租户")
    private Long sysTenantId;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 1, required = true)
    @NotBlank(message = "应用编码为空")
    private String appCode;

    /**
     * 数据源url
     */
    @ApiModelProperty(value = "数据源url", position = 2, required = true)
    @NotBlank(message = "数据源url为空")
    private String dsUrl;

    /**
     * username
     */
    @ApiModelProperty(value = "username", position = 3, required = true)
    @NotBlank(message = "username为空")
    private String dsUsername;

    /**
     * password
     */
    @ApiModelProperty(value = "password", position = 4, required = true)
    @NotBlank(message = "password为空")
    private String dsPassword;

    /**
     * 驱动类
     */
    @ApiModelProperty(value = "驱动类", position = 5, required = true)
    @NotBlank(message = "驱动类为空")
    private String dsDriver;

    /**
     * 连接池配置
     */
    @ApiModelProperty(value = "连接池配置", position = 6)
    private String dsPoolProp;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 7)
    private Boolean enabled;

    /**
     * 是否使用默认
     */
    @ApiModelProperty(value = "是否使用默认", position = 8)
    private Boolean useDef;
}
