/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.provider;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.vo.SysUserPagingVO;
import com.elitescloud.cloudt.system.service.vo.component.SysUserComponentPagingVO;
import com.elitescloud.cloudt.system.spi.SysUserQuerySpi;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SysUserQueryProvider
implements SysUserQuerySpi {
    private static final QSysUserDO Q_SYS_USER_DO = QSysUserDO.sysUserDO;
    private static final QSysTenantUserDO Q_SYS_TENANT_USER_DO = QSysTenantUserDO.sysTenantUserDO;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    public String getServiceName() {
        return "\u79df\u6237\u670d\u52a1";
    }

    public JPAQuery<SysUserDO> selectSysUserForJpaQuery() {
        if (!this.tenantClientProvider.enabledTenant()) {
            return null;
        }
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (!this.needFilter(user)) {
            return null;
        }
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Q_SYS_USER_DO).from((EntityPath)Q_SYS_USER_DO)).leftJoin((EntityPath)Q_SYS_TENANT_USER_DO)).on((Predicate)SysUserQueryProvider.Q_SYS_USER_DO.id.eq((Expression)SysUserQueryProvider.Q_SYS_TENANT_USER_DO.sysUserId));
    }

    public Predicate selectSysUserForPredicate() {
        if (!this.tenantClientProvider.enabledTenant()) {
            return null;
        }
        return this.filterByTenant();
    }

    public JPAQuery<SysUserPagingVO> findPagingForJpaQuery() {
        if (!this.tenantClientProvider.enabledTenant()) {
            return null;
        }
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (!this.needFilter(user)) {
            return null;
        }
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysUserPagingVO.class, (Expression[])new Expression[]{SysUserQueryProvider.Q_SYS_USER_DO.id, SysUserQueryProvider.Q_SYS_USER_DO.username, SysUserQueryProvider.Q_SYS_USER_DO.lastName, SysUserQueryProvider.Q_SYS_USER_DO.firstName, SysUserQueryProvider.Q_SYS_USER_DO.mobile, SysUserQueryProvider.Q_SYS_USER_DO.email, SysUserQueryProvider.Q_SYS_USER_DO.enabled})).from((EntityPath)Q_SYS_USER_DO)).leftJoin((EntityPath)Q_SYS_TENANT_USER_DO)).on((Predicate)SysUserQueryProvider.Q_SYS_USER_DO.id.eq((Expression)SysUserQueryProvider.Q_SYS_TENANT_USER_DO.sysUserId));
    }

    public Predicate findPagingForPredicate() {
        if (!this.tenantClientProvider.enabledTenant()) {
            return null;
        }
        return this.filterByTenant();
    }

    public JPAQuery<SysUserComponentPagingVO> findSysUserComPagingByParamForJpaQuery() {
        if (!this.tenantClientProvider.enabledTenant()) {
            return null;
        }
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (!this.needFilter(user)) {
            return null;
        }
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysUserComponentPagingVO.class, (Expression[])new Expression[]{SysUserQueryProvider.Q_SYS_USER_DO.id, SysUserQueryProvider.Q_SYS_USER_DO.username, SysUserQueryProvider.Q_SYS_USER_DO.lastName, SysUserQueryProvider.Q_SYS_USER_DO.firstName, SysUserQueryProvider.Q_SYS_USER_DO.mobile, SysUserQueryProvider.Q_SYS_USER_DO.email})).from((EntityPath)Q_SYS_USER_DO)).leftJoin((EntityPath)Q_SYS_TENANT_USER_DO)).on((Predicate)SysUserQueryProvider.Q_SYS_USER_DO.id.eq((Expression)SysUserQueryProvider.Q_SYS_TENANT_USER_DO.sysUserId));
    }

    public Predicate findSysUserComPagingByParamForPredicate() {
        if (!this.tenantClientProvider.enabledTenant()) {
            return null;
        }
        return this.filterByTenant();
    }

    private boolean needFilter(GeneralUserDetails user) {
        if (user == null) {
            return false;
        }
        return !user.isSystemAdmin() && !user.isOperation();
    }

    private Predicate filterByTenant() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (!this.needFilter(user)) {
            return null;
        }
        SysTenantDTO tenant = user.getTenant();
        if (tenant == null) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u6682\u672a\u7ed1\u5b9a\u79df\u6237");
        }
        return SysUserQueryProvider.Q_SYS_TENANT_USER_DO.sysTenantId.eq((Object)tenant.getId()).and((Predicate)SysUserQueryProvider.Q_SYS_TENANT_USER_DO.sysUserId.ne((Object)tenant.getSysUserId()));
    }
}

