package com.elitescloud.cloudt.tenant.model.vo.params;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 租户数据源信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/27
 */
@Data
@ApiModel(description = "租户数据源信息")
public class SysTenantDatasourceRespVO implements Serializable {
    private static final long serialVersionUID = 7126050449636600137L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 数据源url
     */
    @ApiModelProperty(value = "数据源url", position = 2)
    private String dsUrl;

    /**
     * username
     */
    @ApiModelProperty(value = "username", position = 3)
    private String dsUsername;

    /**
     * password
     */
    @ApiModelProperty(value = "password", position = 4)
    private String dsPassword;

    /**
     * 驱动类
     */
    @ApiModelProperty(value = "驱动类", position = 5)
    private String dsDriver;

    /**
     * 连接池配置
     */
    @ApiModelProperty(value = "连接池配置", position = 6)
    private String dsPoolProp;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 7)
    private Boolean enabled;

    /**
     * 是否使用默认
     */
    @ApiModelProperty(value = "是否使用默认", position = 8)
    private Boolean useDef;
}
