package com.elitesland.cbpl.infinity.client.router.util;

import com.elitesland.cbpl.infinity.client.router.vo.RouterAuthVO;
import org.apache.commons.codec.binary.Base64;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/04/20
 */
public class InfinityUtil {

    /**
     * Basic Auth
     *
     * @param routerAuth 接口相关参数
     * @return 加密后的头部信息
     */
    public static Map<String, String> setBasicAuth(RouterAuthVO routerAuth) {
        Map<String, String> headers = new HashMap<>();
        String auth = routerAuth.getUsername() + ":" + routerAuth.getPassword();
        byte[] encodedAuth = Base64.encodeBase64((auth.getBytes(StandardCharsets.US_ASCII)));
        String authHeader = "Basic " + new String(encodedAuth);
        headers.put("Authorization", authHeader);
        return headers;
    }
}
