/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.router.service;

import com.elitesland.cbpl.infinity.client.router.convert.RouterConvert;
import com.elitesland.cbpl.infinity.client.router.service.RouterAuthService;
import com.elitesland.cbpl.infinity.client.router.vo.RouterAuthVO;
import com.elitesland.cbpl.infinity.server.platform.service.InfinityPlatformService;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.InfinityPlatformRespVO;
import com.elitesland.cbpl.infinity.server.router.service.InfinityRouterService;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.server.router.vo.resp.InfinityRouterRespVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RouterAuthServiceImpl
implements RouterAuthService {
    private static final Logger log = LoggerFactory.getLogger(RouterAuthServiceImpl.class);
    private final InfinityRouterService routerService;
    private final InfinityPlatformService platformService;

    @Override
    public RouterAuthVO queryRouterAuth(InfinityRouterParamVO routerParam) {
        InfinityPlatformRespVO auth = this.platformService.queryOneAuth(routerParam);
        RouterAuthVO result = RouterConvert.INSTANCE.authToDTO(auth);
        routerParam.setAuthId(auth.getId());
        InfinityRouterRespVO router = this.routerService.queryOneApi(routerParam);
        result.setRouter(router);
        return result;
    }

    public RouterAuthServiceImpl(InfinityRouterService routerService, InfinityPlatformService platformService) {
        this.routerService = routerService;
        this.platformService = platformService;
    }
}

