/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.track.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.cbpl.infinity.client.config.InfinityClientConfig;
import com.elitesland.cbpl.infinity.client.track.service.InfinityTrackService;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.es.domain.TrackEvent;
import com.elitesland.cbpl.tool.es.repository.ElasticsearchRepository;
import com.elitesland.cbpl.tool.es.service.ElasticTrackService;
import com.elitesland.cbpl.tool.es.util.ElasticsearchUtil;
import com.elitesland.cbpl.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class InfinityTrackServiceImpl
implements InfinityTrackService {
    private static final Logger log = LoggerFactory.getLogger(InfinityTrackServiceImpl.class);
    private static final String IDX_INFINITY = "infinity_track";
    @Resource
    private TaskExecutor taskExecutor;
    @Resource
    private ElasticsearchRepository elasticRepository;
    private final ElasticTrackService elasticTrackService;

    @Override
    public void log(HttpServletRequest request, SysTenantDTO tenant) {
        this.addLog(request, tenant, "OK");
    }

    @Override
    public void error(HttpServletRequest request, String errorMessage) {
        this.addLog(request, null, errorMessage);
    }

    private void addLog(HttpServletRequest request, SysTenantDTO tenant, String errorMessage) {
        CompletableFuture.runAsync(() -> {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("CURRENT_TENANT", ObjectUtil.isNull((Object)tenant) ? "-1" : tenant.getId().toString());
            param.put("REQUEST_URL", request.getRequestURL());
            param.put("REQUEST_METHOD", request.getMethod());
            param.put("REQUEST_HEADER", HttpServletUtil.getHeaders((HttpServletRequest)request));
            param.put("REQUEST_PARAMS", ServletUtil.getParams((ServletRequest)request));
            String bodyJsonStr = BeanUtils.toJsonStr((Object)((Map)BeanUtils.toBean((String)ServletUtil.getBody((ServletRequest)request), Map.class)));
            param.put("REQUEST_BODY", bodyJsonStr);
            param.put("ERROR_MESSAGE", errorMessage);
            String indexName = ElasticsearchUtil.indexNameByDay((String)IDX_INFINITY);
            this.checkIndex(indexName);
            this.elasticTrackService.addTrackLog(request, indexName, TrackEvent.TRACK_INFINITY.name(), param);
        }, (Executor)this.taskExecutor).whenComplete((resp, ex) -> {
            if (ObjectUtil.isNotNull((Object)ex)) {
                log.error(ExceptionUtil.formatException((Throwable)ex));
            }
        });
    }

    private void checkIndex(String indexName) {
        boolean exists = this.elasticRepository.existsIndex(indexName);
        if (!exists) {
            String policy = StrUtil.blankToDefault((CharSequence)InfinityClientConfig.INFINITY_POLICY_NAME, (String)"");
            String alias = StrUtil.blankToDefault((CharSequence)InfinityClientConfig.INFINITY_ROLLOVER_ALIAS, (String)"");
            this.elasticRepository.createIndex(indexName, policy, alias);
        }
    }

    public InfinityTrackServiceImpl(ElasticTrackService elasticTrackService) {
        this.elasticTrackService = elasticTrackService;
    }
}

