package com.elitesland.cbpl.infinity.client.router.service;

import com.elitesland.cbpl.infinity.client.router.builder.RouterParamBuilder;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.web.common.vo.ResponseVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.http.service.RestClient;
import com.elitesland.cbpl.infinity.web.util.BeanConvertUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/04/06
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RouterClientServiceImpl implements RouterClientService {

    private final RouterParamBuilder routerParamBuilder;
    private final RestClient restClient;

    @Override
    public <T, K extends ResponseVO> List<T> query(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<T> resultType, Class<K> responseType) {
        HttpParam<T, K> routerParam = routerParamBuilder.routerParamBuilder(param, requestBody, resultType, responseType);
        try {
            K response = exchange(routerParam);
            if (ResponseVO.success(response, "S")) {
                List<Map<String, Object>> entities = response.getData();
                log.trace("[HTTP-REQ] RESULT LIST: {}", entities);
                return BeanConvertUtil.toEntities(entities, routerParam.getResultType());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.error("[HTTP-REQ] QUERY FAIL. URL({}), PARAMS:({})", routerParam.getUrl(), BeanConvertUtil.hashMapToString(routerParam.getBody()));
        return Collections.emptyList();
    }

    @Override
    public <K extends ResponseVO> K send(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<K> responseType) {
        HttpParam<Object, K> routerParam = routerParamBuilder.routerParamBuilder(param, requestBody, null, responseType);
        try {
            return exchange(routerParam);
        } catch (IOException e) {
            e.printStackTrace();
        }
        log.error("[HTTP-REQ] PUT FAIL. URL({}), PARAMS:({})", routerParam.getUrl(), BeanConvertUtil.hashMapToString(routerParam.getBody()));
        return ResponseVO.error();
    }

    private <T, K extends ResponseVO> K exchange(HttpParam<T, K> param) throws IOException {
        LocalDateTime startTime = LocalDateTime.now();
        log.debug("[HTTP-REQ] REQUEST START... ...");
        String requestBody = BeanConvertUtil.hashMapToString(param.getBody());
        log.debug("[HTTP-REQ] URL({}), HEADERS:({}), PARAMS:({})", param.getUrl(), param.getHeaders(), requestBody);
        K response = restClient.exchange(param);
        log.debug("[HTTP-REQ] FINISHED. STATUS:({}), MSG:({}). ", response.getCode(), response.getMessage());
        LocalDateTime endTime = LocalDateTime.now();
        Duration duration = Duration.between(endTime, startTime);
        log.debug("[HTTP-REQ] SPEND TIME: {}", duration.toMillis());
        // TODO add log
        return response;
    }
}
