/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.unicom.util;

import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InfinityAdapter
implements UnicomAdapter {
    private static final Logger log = LoggerFactory.getLogger(InfinityAdapter.class);
    private static final String ERR_TENANT_CONTEXT_CONFIG = "\u627e\u4e0d\u5230\u5b9e\u65bd\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";

    public Object filter(List<Object> providers) {
        Optional<Object> customerProvider = providers.stream().filter(this::matchCustomize).findAny();
        if (customerProvider.isPresent()) {
            log.debug("[CBPL-PHOENIX] context provider: {}", (Object)customerProvider.getClass().getSimpleName());
            return customerProvider.get();
        }
        Object generalProvider = providers.stream().filter(this::matchGeneral).findAny().orElseThrow(() -> {
            throw new BusinessException(ERR_TENANT_CONTEXT_CONFIG);
        });
        log.debug("[CBPL-PHOENIX] context provider: {}", (Object)generalProvider.getClass().getSimpleName());
        return generalProvider;
    }

    private boolean matchCustomize(Object provider) {
        UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
        return "OA_TIMS".equals(annotation.value());
    }

    private boolean matchGeneral(Object provider) {
        UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
        return "GENERAL".equals(annotation.value());
    }
}

