package com.elitesland.cbpl.infinity.client.router.service;

import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.web.common.vo.ResponseVO;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

/**
 * @author eric.hao
 * @since 2023/04/06
 */

public interface RouterClientService {

    /**
     * 查询接口
     *
     * @param param        接口/平台参数
     * @param requestBody  请求参数
     * @param resultType   返回数据结果的实体类型
     * @param responseType 响应值的实体类型
     * @param <T>          返回数据结果的实体类型
     * @param <K>          响应值的实体类型
     * @return 查询结果
     */
    <T, K extends ResponseVO> List<T> query(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<T> resultType, Class<K> responseType);

    /**
     * 写入接口：带回调函数
     *
     * @param param        接口/平台参数
     * @param requestBody  请求参数
     * @param responseType 响应值的实体类型
     * @param bizCode      业务主键
     * @param callback     回调函数
     * @param <T>          返回数据结果的实体类型
     * @param <K>          响应值的实体类型
     * @return 写入结果
     */
    default <T, K extends ResponseVO> K send(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<K> responseType, String bizCode, Consumer<K> callback) {
        K response = send(param, requestBody, responseType);
        response.setBizCode(bizCode);
        callback.accept(response);
        return response;
    }

    /**
     * 写入接口：带回调函数
     *
     * @param param        接口/平台参数
     * @param requestBody  请求参数
     * @param responseType 响应值的实体类型
     * @param <K>          响应值的实体类型
     * @return 写入结果
     */
    <K extends ResponseVO> K send(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<K> responseType);

    /**
     * 统一接口调用
     *
     * @param param       接口/平台参数
     * @param requestBody 请求参数
     * @return 请求结果
     */
    String exchange(InfinityRouterParamVO param, Map<String, Object> requestBody);
}
